;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: SPIM_2.inc
;;   Version: 2.6, Updated on 2009/10/15 at 17:11:37
;;  Generated by PSoC Designer 5.0.1127.0
;;
;;  DESCRIPTION:
;;    Assembler include file of SPIM_2 instance of SPIM
;;    user module.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2009. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

; Mask value for global int reg bit for TX instance
SPIM_2_bINT_MASK:             equ 08h
; SPIM interrupt address
SPIM_2_INT_REG:               equ 0e1h

; Do not use, this equate will be removed in a future release
bSPIM_2_INT_MASK:             equ 08h

;--------------------------------------------------
; Register constants and masks
;--------------------------------------------------
SPIM_2_SPIM_MODE_0:             equ   00h      ;MODE 0 - Leading edge latches data - pos clock
SPIM_2_SPIM_MODE_1:             equ   02h      ;MODE 1 - Leading edge latches data - neg clock
SPIM_2_SPIM_MODE_2:             equ   04h      ;MODE 2 - Trailing edge latches data - pos clock
SPIM_2_SPIM_MODE_3:             equ   06h      ;MODE 3 - Trailing edge latches data - neg clock
SPIM_2_SPIM_LSB_FIRST:          equ   80h      ;LSB bit transmitted/received first
SPIM_2_SPIM_MSB_FIRST:          equ   00h      ;MSB bit transmitted/received first

;---------------------------
; SPI Status register masks
;---------------------------
SPIM_2_SPIM_RX_OVERRUN_ERROR:   equ   40h      ;Overrun error in received data
SPIM_2_SPIM_TX_BUFFER_EMPTY:    equ   10h      ;TX Buffer register is ready for next data byte
SPIM_2_SPIM_RX_BUFFER_FULL:     equ   08h      ;RX Buffer register has received current data
SPIM_2_SPIM_SPI_COMPLETE:       equ   20h      ;SPI Tx/Rx cycle has completed

;--------------------------------------------------
; Registers used by SPIM_2
;--------------------------------------------------
SPIM_2_CONTROL_REG: equ 2fh                      ;Control register
SPIM_2_SHIFT_REG:   equ 2ch                      ;TX Shift Register register
SPIM_2_TX_BUFFER_REG:   equ 2dh                  ;TX Buffer Register
SPIM_2_RX_BUFFER_REG:   equ 2eh                  ;RX Buffer Register
SPIM_2_FUNCTION_REG:    equ 2ch                  ;Function register
SPIM_2_INPUT_REG:   equ 2dh                      ;Input register
SPIM_2_OUTPUT_REG:  equ 2eh                      ;Output register

; end of file SPIM_2.inc
