;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: PWM16_2.inc
;;   Version: 2.5, Updated on 2009/10/15 at 17:11:37
;;  Generated by PSoC Designer 5.0.1127.0
;;
;;  DESCRIPTION: Assembler declarations for the PWM16 user module interface
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2009. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for PWM16_2 API's.
;--------------------------------------------------

PWM16_2_CONTROL_REG_START_BIT:             equ 0x01    ; Control register start bit
PWM16_2_INT_REG:                           equ 0x0e1
PWM16_2_INT_MASK:                          equ 0x80


;--------------------------------------------------
; Constants for PWM16_2 user defined values
;--------------------------------------------------

PWM16_2_PERIOD:                            equ 0x3ff
PWM16_2_PULSE_WIDTH:                       equ 0x0


;--------------------------------------------------
; Register Address Constants for PWM16_2
;--------------------------------------------------

PWM16_2_COUNTER_LSB_REG:               equ 0x38   ; DR0 Count register
PWM16_2_COUNTER_MSB_REG:               equ 0x3c
PWM16_2_PERIOD_LSB_REG:                equ 0x39   ; DR1 Period register
PWM16_2_PERIOD_MSB_REG:                equ 0x3d
PWM16_2_COMPARE_LSB_REG:               equ 0x3a   ; DR2 Compare register
PWM16_2_COMPARE_MSB_REG:               equ 0x3e
PWM16_2_CONTROL_LSB_REG:               equ 0x3b   ; Control register
PWM16_2_CONTROL_MSB_REG:               equ 0x3f
PWM16_2_FUNC_LSB_REG:                  equ 0x38   ; Function register
PWM16_2_FUNC_MSB_REG:                  equ 0x3c
PWM16_2_INPUT_LSB_REG:                 equ 0x39   ; Input register
PWM16_2_INPUT_MSB_REG:                 equ 0x3d
PWM16_2_OUTPUT_LSB_REG:                equ 0x3a   ; Output register
PWM16_2_OUTPUT_MSB_REG:                equ 0x3e


;--------------------------------------------------
; PWM16_2 Macro 'Functions'
;--------------------------------------------------

   macro PWM16_2_Start_M
   or    reg[PWM16_2_CONTROL_LSB_REG],  PWM16_2_CONTROL_REG_START_BIT
   endm

   macro PWM16_2_Stop_M
   and   reg[PWM16_2_CONTROL_LSB_REG], ~PWM16_2_CONTROL_REG_START_BIT
   endm

   macro PWM16_2_EnableInt_M
   M8C_EnableIntMask PWM16_2_INT_REG, PWM16_2_INT_MASK
   endm

   macro PWM16_2_DisableInt_M
   M8C_DisableIntMask PWM16_2_INT_REG, PWM16_2_INT_MASK
   endm


; end of file PWM16_2.inc

