; Generated by PSoC Designer 5.0.1127.0
;
INCLUDE "PSoCDynamic.inc"
;==========================================================================
;  PSoCConfig.asm
;  @PSOC_VERSION
;
;  Version: 0.85
;  Revised: June 22, 2004
;  Copyright (c) Cypress Semiconductor 2009. All Rights Reserved.
;
;  This file is generated by the Device Editor on Application Generation.
;  It contains code which loads the configuration data table generated in
;  the file PSoCConfigTBL.asm
;
;  DO NOT EDIT THIS FILE MANUALLY, AS IT IS OVERWRITTEN!!!
;  Edits to this file will not be preserved.
;==========================================================================
;
include "m8c.inc"
include "memory.inc"
include "GlobalParams.inc"

export LoadConfigInit
export _LoadConfigInit
export LoadConfig_miniadpcm27143
export _LoadConfig_miniadpcm27143
export UnloadConfig_miniadpcm27143
export _UnloadConfig_miniadpcm27143
export ReloadConfig_miniadpcm27143
export _ReloadConfig_miniadpcm27143
export LoadConfig_PlayConfig
export _LoadConfig_PlayConfig
export UnloadConfig_PlayConfig
export _UnloadConfig_PlayConfig
export LoadConfig_RecConfig
export _LoadConfig_RecConfig
export UnloadConfig_RecConfig
export _UnloadConfig_RecConfig
export UnloadConfig_Total
export _UnloadConfig_Total
export ACTIVE_CONFIG_STATUS

export NO_SHADOW
export _NO_SHADOW

FLAG_CFG_MASK:      equ 10h         ;M8C flag register REG address bit mask
END_CONFIG_TABLE:   equ ffh         ;end of config table indicator

AREA psoc_config(rom, rel)

;---------------------------------------------------------------------------
; LoadConfigInit - Establish the start-up configuration (except for a few
;                  parameters handled by boot code, like CPU speed). This
;                  function can be called from user code, but typically it
;                  is only called from boot.
;
;       INPUTS: None.
;      RETURNS: Nothing.
; SIDE EFFECTS: Registers are volatile: the A and X registers can be modified!
;               In the large memory model currently only the page
;               pointer registers listed below are modified.  This does
;               not guarantee that in future implementations of this
;               function other page pointer registers will not be
;               modified.
;          
;               Page Pointer Registers Modified: 
;               CUR_PP
;
_LoadConfigInit:
 LoadConfigInit:
    RAM_PROLOGUE RAM_USE_CLASS_4
    RAM_SETPAGE_CUR >ACTIVE_CONFIG_STATUS
	mov		[ACTIVE_CONFIG_STATUS], 0

	lcall	LoadConfig_miniadpcm27143
	lcall	LoadConfigTBL_miniadpcm27143_Ordered


    RAM_EPILOGUE RAM_USE_CLASS_4
    ret

;---------------------------------------------------------------------------
; Load Configuration miniadpcm27143
;
;    Load configuration registers for miniadpcm27143.
;    IO Bank 0 registers a loaded first,then those in IO Bank 1.
;
;       INPUTS: None.
;      RETURNS: Nothing.
; SIDE EFFECTS: Registers are volatile: the CPU A and X registers may be
;               modified as may the Page Pointer registers!
;               In the large memory model currently only the page
;               pointer registers listed below are modified.  This does
;               not guarantee that in future implementations of this
;               function other page pointer registers will not be
;               modified.
;          
;               Page Pointer Registers Modified: 
;               CUR_PP
;
_LoadConfig_miniadpcm27143:
 LoadConfig_miniadpcm27143:
    RAM_PROLOGUE RAM_USE_CLASS_4
	M8C_SetBank1

	push	x
    M8C_SetBank0                    ; Force bank 0
    mov     a, 0                    ; Specify bank 0
    asr     a                       ; Store in carry flag
                                    ; Load bank 0 table:
    mov     A, >LoadConfigTBL_miniadpcm27143_Bank0
    mov     X, <LoadConfigTBL_miniadpcm27143_Bank0
    lcall   LoadConfig              ; Load the bank 0 values

    mov     a, 1                    ; Specify bank 1
    asr     a                       ; Store in carry flag
                                    ; Load bank 1 table:
    mov     A, >LoadConfigTBL_miniadpcm27143_Bank1
    mov     X, <LoadConfigTBL_miniadpcm27143_Bank1
    lcall   LoadConfig              ; Load the bank 1 values

	RAM_SETPAGE_CUR >ACTIVE_CONFIG_STATUS
; set config active bit
	or		[ACTIVE_CONFIG_STATUS+miniadpcm27143_ADDR_OFF], miniadpcm27143_BIT
    M8C_SetBank0                    ; Force return to bank 0
	pop		x

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret

;---------------------------------------------------------------------------
; Reload Configuration miniadpcm27143
;
;    Reload configuration registers for miniadpcm27143.
;    IO Bank 0 registers a loaded first,then those in IO Bank 1.
;
;       INPUTS: None.
;      RETURNS: Nothing.
; SIDE EFFECTS: Registers are volatile: the CPU A and X registers may be
;               modified as may the Page Pointer registers!
;               In the large memory model currently only the page
;               pointer registers listed below are modified.  This does
;               not guarantee that in future implementations of this
;               function other page pointer registers will not be
;               modified.
;          
;               Page Pointer Registers Modified: 
;               CUR_PP
;
_ReloadConfig_miniadpcm27143:
 ReloadConfig_miniadpcm27143:
    RAM_PROLOGUE RAM_USE_CLASS_4

	push	x
    M8C_SetBank0                    ; Force bank 0
    mov     a, 0                    ; Specify bank 0
    asr     a                       ; Store in carry flag
                                    ; Bank 0 table address:
    mov     A, >ReloadConfigTBL_miniadpcm27143_Bank0
    mov     X, <ReloadConfigTBL_miniadpcm27143_Bank0
    lcall   LoadConfig              ; Reload the bank 0 values

    mov     a, 1                    ; Specify bank 1
    asr     a                       ; Store in carry flag
                                    ; Bank 1 table address:
    mov     A, >ReloadConfigTBL_miniadpcm27143_Bank1
    mov     X, <ReloadConfigTBL_miniadpcm27143_Bank1
    lcall   LoadConfig              ; Reload the bank 1 values

; set config active bit
	RAM_SETPAGE_CUR >ACTIVE_CONFIG_STATUS
	or		[ACTIVE_CONFIG_STATUS+miniadpcm27143_ADDR_OFF], miniadpcm27143_BIT
    M8C_SetBank0                    ; Force return to bank 0
	pop		x

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret

;---------------------------------------------------------------------------
; Unload Configuration miniadpcm27143
;
;    Reset configuration registers for miniadpcm27143
;    to their values as initially configured.
;    IO Bank 0 registers a loaded first,then those in IO Bank 1.
;
;       INPUTS: None.
;      RETURNS: Nothing.
; SIDE EFFECTS: Registers are volatile: the CPU A and X registers may be
;               modified as may the Page Pointer registers!
;               In the large memory model currently only the page
;               pointer registers listed below are modified.  This does
;               not guarantee that in future implementations of this
;               function other page pointer registers will not be
;               modified.
;          
;               Page Pointer Registers Modified: 
;               CUR_PP
;
_UnloadConfig_miniadpcm27143:
 UnloadConfig_miniadpcm27143:
    RAM_PROLOGUE RAM_USE_CLASS_4

	push	x
    M8C_SetBank0                    ; Force bank 0
    mov     a, 0                    ; Specify bank 0
    asr     a                       ; Store in carry flag
                                    ; Bank 0 table address:
    mov     A, >UnloadConfigTBL_miniadpcm27143_Bank0
    mov     X, <UnloadConfigTBL_miniadpcm27143_Bank0
    lcall   LoadConfig              ; Unload the bank 0 values

    mov     a, 1                    ; Specify bank 1
    asr     a                       ; Store in carry flag
                                    ; Bank 1 table address:
    mov     A, >UnloadConfigTBL_miniadpcm27143_Bank1
    mov     X, <UnloadConfigTBL_miniadpcm27143_Bank1
    lcall   LoadConfig              ; Unload the bank 1 values

	M8C_SetBank0
; clear config active bit
	RAM_SETPAGE_CUR >ACTIVE_CONFIG_STATUS
	and		[ACTIVE_CONFIG_STATUS+miniadpcm27143_ADDR_OFF], ~miniadpcm27143_BIT
    M8C_SetBank0                    ; Force return to bank 0
	pop		x

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret

;---------------------------------------------------------------------------
; Load Configuration PlayConfig
;
;    Load configuration registers for PlayConfig.
;    IO Bank 0 registers a loaded first,then those in IO Bank 1.
;
;       INPUTS: None.
;      RETURNS: Nothing.
; SIDE EFFECTS: Registers are volatile: the CPU A and X registers may be
;               modified as may the Page Pointer registers!
;               In the large memory model currently only the page
;               pointer registers listed below are modified.  This does
;               not guarantee that in future implementations of this
;               function other page pointer registers will not be
;               modified.
;          
;               Page Pointer Registers Modified: 
;               CUR_PP
;
_LoadConfig_PlayConfig:
 LoadConfig_PlayConfig:
    RAM_PROLOGUE RAM_USE_CLASS_4
	M8C_SetBank1
; writing Port_0_DriveMode_0 register
	and		reg[ 0h], ~24h
	or		reg[ 0h], 24h
; writing Port_0_DriveMode_1 register
	and		reg[ 1h], ~24h
; writing Port_0_DriveMode_2 register
	M8C_SetBank0
	and		reg[ 3h], ~24h
; writing Port_0_GlobalSelect register
	and		reg[ 2h], ~24h
	or		reg[ 2h], 24h
; writing Row_0_OutputDrive_0 register
	and		reg[b5h], ~20h
	or		reg[b5h], 20h
; writing Row_0_OutputDrive_1 register
	and		reg[b6h], ~ 1h
	or		reg[b6h],  1h

	push	x
    M8C_SetBank0                    ; Force bank 0
    mov     a, 0                    ; Specify bank 0
    asr     a                       ; Store in carry flag
                                    ; Load bank 0 table:
    mov     A, >LoadConfigTBL_PlayConfig_Bank0
    mov     X, <LoadConfigTBL_PlayConfig_Bank0
    lcall   LoadConfig              ; Load the bank 0 values

    mov     a, 1                    ; Specify bank 1
    asr     a                       ; Store in carry flag
                                    ; Load bank 1 table:
    mov     A, >LoadConfigTBL_PlayConfig_Bank1
    mov     X, <LoadConfigTBL_PlayConfig_Bank1
    lcall   LoadConfig              ; Load the bank 1 values

	RAM_SETPAGE_CUR >ACTIVE_CONFIG_STATUS
; set config active bit
	or		[ACTIVE_CONFIG_STATUS+PlayConfig_ADDR_OFF], PlayConfig_BIT
    M8C_SetBank0                    ; Force return to bank 0
	pop		x

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret

;---------------------------------------------------------------------------
; Unload Configuration PlayConfig
;
;    Reset configuration registers for PlayConfig
;    to their values as initially configured.
;    IO Bank 0 registers a loaded first,then those in IO Bank 1.
;
;       INPUTS: None.
;      RETURNS: Nothing.
; SIDE EFFECTS: Registers are volatile: the CPU A and X registers may be
;               modified as may the Page Pointer registers!
;               In the large memory model currently only the page
;               pointer registers listed below are modified.  This does
;               not guarantee that in future implementations of this
;               function other page pointer registers will not be
;               modified.
;          
;               Page Pointer Registers Modified: 
;               CUR_PP
;
_UnloadConfig_PlayConfig:
 UnloadConfig_PlayConfig:
    RAM_PROLOGUE RAM_USE_CLASS_4

	push	x
    M8C_SetBank0                    ; Force bank 0
    mov     a, 0                    ; Specify bank 0
    asr     a                       ; Store in carry flag
                                    ; Bank 0 table address:
    mov     A, >UnloadConfigTBL_PlayConfig_Bank0
    mov     X, <UnloadConfigTBL_PlayConfig_Bank0
    lcall   LoadConfig              ; Unload the bank 0 values

    mov     a, 1                    ; Specify bank 1
    asr     a                       ; Store in carry flag
                                    ; Bank 1 table address:
    mov     A, >UnloadConfigTBL_PlayConfig_Bank1
    mov     X, <UnloadConfigTBL_PlayConfig_Bank1
    lcall   LoadConfig              ; Unload the bank 1 values

	M8C_SetBank0
; writing Row_0_OutputDrive_0 register
	and		reg[b5h], ~20h
; writing Row_0_OutputDrive_1 register
	and		reg[b6h], ~ 1h
; writing Port_0_GlobalSelect register
	and		reg[ 2h], ~24h
; writing Port_0_DriveMode_2 register
	and		reg[ 3h], ~24h
	or		reg[ 3h], 24h
; writing Port_0_DriveMode_1 register
	M8C_SetBank1
	and		reg[ 1h], ~24h
	or		reg[ 1h], 24h
; writing Port_0_DriveMode_0 register
	and		reg[ 0h], ~24h
	M8C_SetBank0
; clear config active bit
	RAM_SETPAGE_CUR >ACTIVE_CONFIG_STATUS
	and		[ACTIVE_CONFIG_STATUS+PlayConfig_ADDR_OFF], ~PlayConfig_BIT
    M8C_SetBank0                    ; Force return to bank 0
	pop		x

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret

;---------------------------------------------------------------------------
; Load Configuration RecConfig
;
;    Load configuration registers for RecConfig.
;    IO Bank 0 registers a loaded first,then those in IO Bank 1.
;
;       INPUTS: None.
;      RETURNS: Nothing.
; SIDE EFFECTS: Registers are volatile: the CPU A and X registers may be
;               modified as may the Page Pointer registers!
;               In the large memory model currently only the page
;               pointer registers listed below are modified.  This does
;               not guarantee that in future implementations of this
;               function other page pointer registers will not be
;               modified.
;          
;               Page Pointer Registers Modified: 
;               CUR_PP
;
_LoadConfig_RecConfig:
 LoadConfig_RecConfig:
    RAM_PROLOGUE RAM_USE_CLASS_4
	M8C_SetBank1
; writing DecimatorControl_1 register
	M8C_SetBank0
	and		reg[e7h], ~ 7h
	or		reg[e7h],  2h

	push	x
    M8C_SetBank0                    ; Force bank 0
    mov     a, 0                    ; Specify bank 0
    asr     a                       ; Store in carry flag
                                    ; Load bank 0 table:
    mov     A, >LoadConfigTBL_RecConfig_Bank0
    mov     X, <LoadConfigTBL_RecConfig_Bank0
    lcall   LoadConfig              ; Load the bank 0 values

    mov     a, 1                    ; Specify bank 1
    asr     a                       ; Store in carry flag
                                    ; Load bank 1 table:
    mov     A, >LoadConfigTBL_RecConfig_Bank1
    mov     X, <LoadConfigTBL_RecConfig_Bank1
    lcall   LoadConfig              ; Load the bank 1 values

	RAM_SETPAGE_CUR >ACTIVE_CONFIG_STATUS
; set config active bit
	or		[ACTIVE_CONFIG_STATUS+RecConfig_ADDR_OFF], RecConfig_BIT
    M8C_SetBank0                    ; Force return to bank 0
	pop		x

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret

;---------------------------------------------------------------------------
; Unload Configuration RecConfig
;
;    Reset configuration registers for RecConfig
;    to their values as initially configured.
;    IO Bank 0 registers a loaded first,then those in IO Bank 1.
;
;       INPUTS: None.
;      RETURNS: Nothing.
; SIDE EFFECTS: Registers are volatile: the CPU A and X registers may be
;               modified as may the Page Pointer registers!
;               In the large memory model currently only the page
;               pointer registers listed below are modified.  This does
;               not guarantee that in future implementations of this
;               function other page pointer registers will not be
;               modified.
;          
;               Page Pointer Registers Modified: 
;               CUR_PP
;
_UnloadConfig_RecConfig:
 UnloadConfig_RecConfig:
    RAM_PROLOGUE RAM_USE_CLASS_4

	push	x
    M8C_SetBank0                    ; Force bank 0
    mov     a, 0                    ; Specify bank 0
    asr     a                       ; Store in carry flag
                                    ; Bank 0 table address:
    mov     A, >UnloadConfigTBL_RecConfig_Bank0
    mov     X, <UnloadConfigTBL_RecConfig_Bank0
    lcall   LoadConfig              ; Unload the bank 0 values

    mov     a, 1                    ; Specify bank 1
    asr     a                       ; Store in carry flag
                                    ; Bank 1 table address:
    mov     A, >UnloadConfigTBL_RecConfig_Bank1
    mov     X, <UnloadConfigTBL_RecConfig_Bank1
    lcall   LoadConfig              ; Unload the bank 1 values

	M8C_SetBank0
; writing DecimatorControl_1 register
	and		reg[e7h], ~ 7h
; clear config active bit
	RAM_SETPAGE_CUR >ACTIVE_CONFIG_STATUS
	and		[ACTIVE_CONFIG_STATUS+RecConfig_ADDR_OFF], ~RecConfig_BIT
    M8C_SetBank0                    ; Force return to bank 0
	pop		x

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret

;---------------------------------------------------------------------------
; Unload Configuration Total
;
;    Reset configuration registers for Total
;    to their values as initially configured.
;    IO Bank 0 registers a loaded first,then those in IO Bank 1.
;
;       INPUTS: None.
;      RETURNS: Nothing.
; SIDE EFFECTS: Registers are volatile: the CPU A and X registers may be
;               modified as may the Page Pointer registers!
;               In the large memory model currently only the page
;               pointer registers listed below are modified.  This does
;               not guarantee that in future implementations of this
;               function other page pointer registers will not be
;               modified.
;          
;               Page Pointer Registers Modified: 
;               CUR_PP
;
_UnloadConfig_Total:
 UnloadConfig_Total:
    RAM_PROLOGUE RAM_USE_CLASS_4

	push	x
    M8C_SetBank0                    ; Force bank 0
    mov     a, 0                    ; Specify bank 0
    asr     a                       ; Store in carry flag
                                    ; Bank 0 table address:
    mov     A, >UnloadConfigTBL_Total_Bank0
    mov     X, <UnloadConfigTBL_Total_Bank0
    lcall   LoadConfig              ; Unload the bank 0 values

    mov     a, 1                    ; Specify bank 1
    asr     a                       ; Store in carry flag
                                    ; Bank 1 table address:
    mov     A, >UnloadConfigTBL_Total_Bank1
    mov     X, <UnloadConfigTBL_Total_Bank1
    lcall   LoadConfig              ; Unload the bank 1 values

	M8C_SetBank0
; clear config active bit
	RAM_SETPAGE_CUR >ACTIVE_CONFIG_STATUS
	mov		[ACTIVE_CONFIG_STATUS+0], 0
    M8C_SetBank0                    ; Force return to bank 0
	pop		x

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret




;---------------------------------------------------------------------------
; LoadConfig - Set IO registers as specified in ROM table of (address,value)
;              pairs. Terminate on address=0xFF.
;
;  INPUTS:  [A,X] points to the table to be loaded
;           Flag Register Carry bit encodes the Register Bank
;           (Carry=0 => Bank 0; Carry=1 => Bank 1)
;
;  RETURNS: nothing.
;
;  STACK FRAME:  X-4 I/O Bank 0/1 indicator
;                X-3 Temporary store for register address
;                X-2 LSB of config table address
;                X-1 MSB of config table address
;
LoadConfig:
    RAM_PROLOGUE RAM_USE_CLASS_2
    add     SP, 2                   ; Set up local vars
    push    X                       ; Save config table address on stack
    push    A
    mov     X, SP
    mov     [X-4], 0                ; Set default Destination to Bank 0
    jnc     .BankSelectSaved        ; Carry says Bank 0 is OK
    mov     [X-4], 1                ; No Carry: default to Bank 1
.BankSelectSaved:
    pop     A
    pop     X

LoadConfigLp:
    M8C_SetBank0                    ; Switch to bank 0
    M8C_ClearWDT                    ; Clear the watchdog for long inits
    push    X                       ; Preserve the config table address
    push    A
    romx                            ; Load register address from table
    cmp     A, END_CONFIG_TABLE     ; End of table?
    jz      EndLoadConfig           ;   Yes, go wrap it up
    mov     X, SP                   ;
    tst     [X-4], 1                ; Loading IO Bank 1?
    jz      .IOBankNowSet           ;    No, Bank 0 is fine
    M8C_SetBank1                    ;   Yes, switch to Bank 1
.IOBankNowSet:
    mov     [X-3], A                ; Stash the register address
    pop     A                       ; Retrieve the table address
    pop     X
    inc     X                       ; Advance to the data byte
    adc     A, 0
    push    X                       ; Save the config table address again
    push    A
    romx                            ; load config data from the table
    mov     X, SP                   ; retrieve the register address
    mov     X, [X-3]
    mov     reg[X], A               ; Configure the register
    pop     A                       ; retrieve the table address
    pop     X
    inc     X                       ; advance to next table entry
    adc     A, 0
    jmp     LoadConfigLp            ; loop to configure another register
EndLoadConfig:
    add     SP, -4
    RAM_EPILOGUE RAM_USE_CLASS_2
    ret

AREA InterruptRAM(ram, rel)

NO_SHADOW:
_NO_SHADOW:
; active configuration status byte
ACTIVE_CONFIG_STATUS:	BLK	1

AREA text(rom, rel)
