;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: DELSIG8_1.asm
;;   Version: 3.2, Updated on 2009/10/23 at 10:13:12
;;  Generated by PSoC Designer 5.0.1127.0
;;
;;  DESCRIPTION: Assembler source for the 8-bit Delta-Sigma A/D Converter
;;               User Module with 2nd-order modulator.
;;
;;  NOTE: User Module APIs conform to the fastcall16 convention for marshalling
;;        arguments and observe the associated "Registers are volatile" policy.
;;        This means it is the caller's responsibility to preserve any values
;;        in the X and A registers that are still needed after the API functions
;;        returns. For Large Memory Model devices it is also the caller's 
;;        responsibility to perserve any value in the CUR_PP, IDX_PP, MVR_PP and 
;;        MVW_PP registers. Even though some of these registers may not be modified
;;        now, there is no guarantee that will remain the case in future releases.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2009. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"
include "memory.inc"			    ; see this for RAM use & proxy classes
include "DELSIG8_1.inc"


;-----------------------------------------------
;  Global Symbols
;-----------------------------------------------
export  DELSIG8_1_Start
export _DELSIG8_1_Start
export  DELSIG8_1_SetPower
export _DELSIG8_1_SetPower
export  DELSIG8_1_Stop
export _DELSIG8_1_Stop
export  DELSIG8_1_StartAD
export _DELSIG8_1_StartAD
export  DELSIG8_1_StopAD
export _DELSIG8_1_StopAD

IF (DELSIG8_1_POLL_ENABLE)
export  DELSIG8_1_fIsDataAvailable:
export _DELSIG8_1_fIsDataAvailable:
export  DELSIG8_1_cGetDataClearFlag:
export _DELSIG8_1_cGetDataClearFlag:
export  DELSIG8_1_cGetData:
export _DELSIG8_1_cGetData:
export  DELSIG8_1_ClearFlag:
export _DELSIG8_1_ClearFlag:
ENDIF


;-----------------------------------------------
;  Constant Definitions
;-----------------------------------------------

CONTROL_REG_ENABLE_BIT:                    equ  01h     ; Control register start bit
POWERMASK:                                 equ  03h     ; Analog PSoC Block Power bits
NOAZ:                                      equ  1       ;
SC_AZ_MASK:                                equ  20h     ; Switched Cap Auto Zero bit
SC_FSW0_MASK:                              equ  10h     ; Switched Cap Feedback '0' switch


AREA UserModules (ROM, REL)

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: DELSIG8_1_Start
;  FUNCTION NAME: DELSIG8_1_SetPower
;
;  DESCRIPTION: Applies power setting to the module's analog PSoc blocks.
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:    The A register contains the power setting.
;  RETURNS:      Nothing.
;  SIDE EFFECTS: 
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 DELSIG8_1_Start:
_DELSIG8_1_Start:
 DELSIG8_1_SetPower:
_DELSIG8_1_SetPower:
   RAM_PROLOGUE   RAM_USE_CLASS_2
   mov  X, SP                                    ; Set up Stack frame
   and  A, POWERMASK                             ; Ensure value is legal
   push A
   mov  A, reg[DELSIG8_1_AtoD1cr3]               ; First SC block:
   and  A, ~POWERMASK                            ;   clear power bits to zero
   or   A, [ X ]                                 ;   establish new value
   mov  reg[DELSIG8_1_AtoD1cr3], A               ;   change the actual setting
   mov  A,reg[DELSIG8_1_AtoD2cr3]                ; Second SC block: as previous
   and  A,~POWERMASK
   or   A,[ X ]
   mov  reg[DELSIG8_1_AtoD2cr3],A
   pop  A
   RAM_EPILOGUE  RAM_USE_CLASS_2
   ret
.ENDSECTION


.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: DELSIG8_1_Stop
;
;  DESCRIPTION:   Removes power from the module's analog PSoc blocks.
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:     None.
;  RETURNS:       Nothing.
;  SIDE EFFECTS: 
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 DELSIG8_1_Stop:
_DELSIG8_1_Stop:
   RAM_PROLOGUE   RAM_USE_CLASS_1
   and  reg[DELSIG8_1_AtoD1cr3], ~POWERMASK
   and  reg[DELSIG8_1_AtoD2cr3], ~POWERMASK
   RAM_EPILOGUE  RAM_USE_CLASS_1
   ret
.ENDSECTION


.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: DELSIG8_1_StartAD
;
;  DESCRIPTION: Activates interrupts for this user module and begins sampling.
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:    None.
;  RETURNS:      Nothing.
;  SIDE EFFECTS: 
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 DELSIG8_1_StartAD:
_DELSIG8_1_StartAD:
   RAM_PROLOGUE   RAM_USE_CLASS_1

   M8C_SetBank1
   and reg[E7h], 3Fh             ; if we are in 29xxx then this sets decimator to comp mode   
   M8C_SetBank0

   M8C_EnableIntMask DELSIG8_1_INT_REG, DELSIG8_1_INT_MASK          ; Enable timer interrupt
   and  reg[DELSIG8_1_AtoD1cr3], ~SC_FSW0_MASK       ; Enable the Integrator ...
   and  reg[DELSIG8_1_AtoD2cr3], ~SC_FSW0_MASK       ;   (both blocks)

IF NOAZ
   and  reg[DELSIG8_1_AtoD1cr2], ~SC_AZ_MASK         ; Turn off AutoZero
   and  reg[DELSIG8_1_AtoD2cr2], ~SC_AZ_MASK         ;  (both blocks)
ENDIF
                                                     ; Initialize Timer ...
   mov  reg[DELSIG8_1_TimerDR1], FFh                 ;   set period = 256
   mov  reg[DELSIG8_1_TimerCR0], CONTROL_REG_ENABLE_BIT
   RAM_EPILOGUE  RAM_USE_CLASS_1
   ret
.ENDSECTION


.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: DELSIG8_1_StopAD
;
;  DESCRIPTION: Shuts down the A/D is an orderly manner.  The Timer stops
;               operating and it's interrupt is disabled. Analog power is
;               still supplied to the analog blocks, however.
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:    None.
;  RETURNS:      Nothing.
;  SIDE EFFECTS: 
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 DELSIG8_1_StopAD:
_DELSIG8_1_StopAD:
   RAM_PROLOGUE   RAM_USE_CLASS_1

   M8C_SetBank1
   or  reg[E7h], 80h             ; if we are in 29xxx then this sets decimator to full alg. mode   
   M8C_SetBank0

   mov  reg[DELSIG8_1_TimerCR0], 00h                 ; Disable the Timer
   M8C_DisableIntMask DELSIG8_1_INT_REG, DELSIG8_1_INT_MASK         ; Disable its interrupt
IF NOAZ
   or   reg[DELSIG8_1_AtoD1cr2], SC_AZ_MASK          ; Force the Integrator into reset
   or   reg[DELSIG8_1_AtoD2cr2],SC_AZ_MASK           ;
ENDIF
   or   reg[DELSIG8_1_AtoD1cr3], SC_FSW0_MASK        ; Reset Integrator
   or   reg[DELSIG8_1_AtoD2cr3],SC_FSW0_MASK         ;
   RAM_EPILOGUE  RAM_USE_CLASS_1
   ret
.ENDSECTION


IF (DELSIG8_1_POLL_ENABLE)

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: DELSIG8_1_fIsDataAvailable
;
;  DESCRIPTION: Returns the status of the A/D Data
;-----------------------------------------------------------------------------
;  ARGUMENTS:    None.
;  RETURNS:      fastcall16 BOOL DataAvailable returned in the A register
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
;    Currently only the page pointer registers listed below are modified:
;          CUR_PP
;
 DELSIG8_1_fIsDataAvailable:
_DELSIG8_1_fIsDataAvailable:
   RAM_PROLOGUE   RAM_USE_CLASS_4
   RAM_SETPAGE_CUR >DELSIG8_1_bfStatus
   mov  A, [DELSIG8_1_bfStatus]
   RAM_EPILOGUE  RAM_USE_CLASS_4
   ret
.ENDSECTION


.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME:  DELSIG8_1_cGetDataClearFlag
;
;  DESCRIPTION:    Returns the data from the A/D.  Does not check if data is
;                  available. Also clears the DATA_READY flag.
;-----------------------------------------------------------------------------
;  ARGUMENTS:    None.
;  RETURNS:      fastcall16 CHAR cData returned in the A register
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
;    Currently only the page pointer registers listed below are modified:
;          CUR_PP
;
 DELSIG8_1_cGetDataClearFlag:
_DELSIG8_1_cGetDataClearFlag:
   RAM_PROLOGUE   RAM_USE_CLASS_4
   RAM_SETPAGE_CUR >DELSIG8_1_bfStatus
   and  [DELSIG8_1_bfStatus], ~DELSIG8_1_DATA_READY_BIT
   mov  A, [DELSIG8_1_cResult]
   RAM_EPILOGUE  RAM_USE_CLASS_4
   ret
.ENDSECTION


.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME:  DELSIG8_1_cGetData:
;
;  DESCRIPTION:     Returns the data from the A/D.  Does not check if data is
;                   available.
;-----------------------------------------------------------------------------
;  ARGUMENTS:    None.
;  RETURNS:      fastcall16 CHAR cData returned in the A register
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
;    Currently only the page pointer registers listed below are modified:
;          CUR_PP
;
 DELSIG8_1_cGetData:
_DELSIG8_1_cGetData:
   RAM_PROLOGUE   RAM_USE_CLASS_4
   RAM_SETPAGE_CUR >DELSIG8_1_cResult
   mov  A, [DELSIG8_1_cResult]
   RAM_EPILOGUE  RAM_USE_CLASS_4
   ret
.ENDSECTION


.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: DELSIG8_1_ClearFlag
;
;  DESCRIPTION: Clears the data ready flag.
;-----------------------------------------------------------------------------
;  ARGUMENTS:    None.
;  RETURNS:      Nothing.
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
;    Currently only the page pointer registers listed below are modified:
;          CUR_PP
;
 DELSIG8_1_ClearFlag:
_DELSIG8_1_ClearFlag:
   RAM_PROLOGUE   RAM_USE_CLASS_4
   RAM_SETPAGE_CUR >DELSIG8_1_bfStatus
   and  [DELSIG8_1_bfStatus], ~DELSIG8_1_DATA_READY_BIT
   RAM_EPILOGUE  RAM_USE_CLASS_4
   ret
.ENDSECTION


ENDIF


; End of File DELSIG8_1.asm
