//----------------------------------------------------------------------------
// C main line
//----------------------------------------------------------------------------

#include <m8c.h>        // part specific constants and macros
#include "PSoCAPI.h"    // PSoC API definitions for all User Modules


unsigned char StepTbl[10] = {
3 ,4 ,4 ,4 ,4 ,5 ,6 ,7 ,8 ,9
};

signed char scale_change_tbl[8] = {
-1, -1, -1, -1, 1, 1, 1, 2};

unsigned char	scale;
signed int	adpcmdata;
unsigned char	scale2;
signed int	adpcmdata2;


void ADPCMEncoderInit(void){
	scale = 0;
	adpcmdata = 0;
}

unsigned char ADPCMEncoder(unsigned char WavePCM)
{
	int diff;
	unsigned char code;
	int dlevel;
	unsigned char step; 
	unsigned char sign;
	
	diff = WavePCM - adpcmdata;
	sign = (diff < 0)? 8 : 0;
	if (sign)diff = (-diff);
	step = StepTbl[scale];
	dlevel = step;
	if(diff >= step){
		code = 4;
		diff -= step;
		dlevel += step;
	}
	step >>= 1;
		if(diff >= step){
		code |= 2;
		diff -= step;
		dlevel += step;
	}
	step >>= 1;
	if(diff >= step){
		code |= 1;
		dlevel += step;
	}



	if(sign & 0x08){
  		adpcmdata -= dlevel;
  		if(adpcmdata < 0)adpcmdata = 0;
	}else{  
	adpcmdata += dlevel;
  	if(adpcmdata > 255)adpcmdata = 255;
	}

	scale += scale_change_tbl[code & 0x07];
	if(scale > 127)scale = 0;	//unsigned char 128 = signed char 0
	else if(scale > 9)scale = 9;
	return((unsigned char)code);
}
