const unsigned char StepTbl[10] = {
3 ,4 ,4 ,4 ,4 ,5 ,6 ,7 ,8 ,9
};

const signed char scale_change_tbl[8] = {
-1, -1, -1, -1, 1, 1, 1, 2};

unsigned char	scale;
signed int	adpcmdata;
unsigned char	scale2;
signed int	adpcmdata2;

void ADPCMDecoderInit(void){
	scale = 0;
	adpcmdata = 0;
	scale2 = 0;
	adpcmdata2 = 0;
}
unsigned char ADPCMDecoder(unsigned char code)
{
	int dlevel;
	//code&=0x0f;
	MUL_X = (code & 0x07);
	MUL_Y = StepTbl[scale];// scale:index
//	dlevel = (MUL_DH << 8) | MUL_DL;
	asm(
	"mov	A,REG[235]	\n"
	"mov	[X+1],A		\n"
	"mov	A,REG[234]	\n"
	"mov	[X+0],A		\n"
	);
	// asm end
	dlevel >>= 1;
	if(code & 0x08){
  		adpcmdata -= dlevel;
		
  		//if(adpcmdata < 0)adpcmdata = 0;
		asm(
		"tst	[_adpcmdata], 128	\n"
		"jz		LABEL_00a			\n"
		"mov	[_adpcmdata], 0		\n"
		"mov	[_adpcmdata+1], 0	\n"
		);
	}else{  
	adpcmdata += dlevel;
  	//if(adpcmdata > 255)adpcmdata = 255;
	asm(
	"mov	a, [_adpcmdata+1]	\n"
	"cmp	a, 0				\n"
	"mov	a, [_adpcmdata]		\n"
	"xor	a, 0x80				\n"
	"sbb	a, 129				\n"
	"jc		LABEL_00a			\n"
	"mov	[_adpcmdata], 0		\n"
	"mov	[_adpcmdata+1], 255	\n"
	);//asm end
	
	}
	asm(
	"LABEL_00a:			\n"
	);
	scale += scale_change_tbl[code & 0x07];
	// if(scale > 127)scale = 0;	//unsigned char 128 = signed char 0
	// else if(scale > 9)scale = 9;
	// asm start
	asm(
	"	CMP	[_scale],128	\n"
	"	JC	LABEL_001		\n"
	"	MOV	[_scale],0		\n"
	"	JMP	LABEL_002		\n"
	
	"LABEL_001:				\n"
	"	CMP	[_scale],10		\n"
	"	JC	LABEL_002		\n"
	"	MOV	[_scale],9		\n"
	"LABEL_002:				\n"
	);
// asm end

	return((unsigned char)adpcmdata);
}
unsigned char ADPCMDecoder2(unsigned char code)
{
	int dlevel;
	MUL_X = (code & 0x07);
	MUL_Y = StepTbl[scale2];

	//	dlevel = (MUL_DH << 8) | MUL_DL;
	asm(
	"MOV	A,REG[235]	\n"
	"MOV	[X+1],A		\n"
	"MOV	A,REG[234]	\n"
	"MOV	[X+0],A		\n"
	);//endasm
	
	dlevel >>= 1;
	if(code & 0x08){
  		adpcmdata2 -= dlevel;
  		//if(adpcmdata2 < 0)adpcmdata2 = 0;
		asm(
		"tst	[_adpcmdata2], 128	\n"
		"jz		LABEL_00b			\n"
		"mov	[_adpcmdata2], 0	\n"
		"mov	[_adpcmdata2+1], 0	\n"
		);		
		
	}else{  
	adpcmdata2 += dlevel;
  	//if(adpcmdata2 > 255)adpcmdata2 = 255;
	asm(
	"	mov		a, [_adpcmdata2+1]	\n"
	"	cmp		a, 0				\n"
	"	mov		a, [_adpcmdata2]	\n"
	"	xor		a, 0x80				\n"
	"	sbb		a, 129				\n"
	"	jc		LABEL_00b			\n"
	"	mov		[_adpcmdata2], 0	\n"
	"	mov		[_adpcmdata2+1], 255\n"
	);
		
	}
	asm(
	"LABEL_00b:		\n"
	);
	scale2 += scale_change_tbl[code & 0x07];
//	if(scale2 > 127)scale2 = 0;
//	else if(scale2 > 9)scale2 = 9;
	asm(
	"	CMP	[_scale2],128	\n"
	"	JC	LABEL_003		\n"
	"	MOV	[_scale2],0		\n"
	"	JMP	LABEL_004		\n"
	"LABEL_003:				\n"
	"	CMP	[_scale2],10	\n"
	"	JC	LABEL_004		\n"
	"	MOV	[_scale2],9		\n"
	"LABEL_004:				\n"
	);

	//DAC9_3_WriteStall((unsigned char)adpcmdata2);
	return((unsigned char)adpcmdata2);
}

