
#include <m8c.h>        // part specific constants and macros
#include "PSoCAPI.h"    // PSoC API definitions for all User Modules
#include "SDCard_FS.c"
#include "adpcm_ima_dvi.c"
#define  CARD_PRESENT      1
#define  CARD_NOT_PRESENT  0
#define  SW1  0x20			//p0_5
#define  SEEK_HEADER 60



volatile unsigned char	PWM_End_Flag;


//#pragma abs_address:0x000

//#pragma end_abs_address
void main() {

	unsigned int		MaxFile;
	unsigned char 	Data,i,L_PCM,R_PCM;
	unsigned long	SDADDRV;
	unsigned long	FILE_LENGTH;
	unsigned char   cardInfo;                      // Card information
	unsigned char   fp2;                           // File Pointer
	BYTE   CardState, oldCardState;       // Card inserted state variables
	unsigned char	port_input_dat;
	unsigned char	port_output_dat;
	unsigned int	LP_01;
	unsigned int Track_N; //Track_N as skipping FAT Table register
	
	
	

	Track_N=1;
	PWM_End_Flag = 1;	// 0:Go, 1:Stop



port_output_dat = SW1;
PRT0DR = port_output_dat;

ADPCMDecoderInit();

/*
DAC9_1_Start(DAC9_1_HIGHPOWER);
DAC9_3_Start(DAC9_3_HIGHPOWER);

PRS8_1_WritePolynomial(0xB8);
PRS8_2_WritePolynomial(0xB8);
PRS8_1_WriteSeed(0xff);   
PRS8_2_WriteSeed(0xff);  
*/ 


PWM16_1_Start();
PWM16_2_Start();
/*
PWM8_1_Start(); 
PWM8_2_Start();
*/
PWM8_1_Start(); 
PWM8_3_Start();



PGA_1_Start(PGA_1_HIGHPOWER);
PGA_3_Start(PGA_3_HIGHPOWER);

BPF2_1_Start(BPF2_1_HIGHPOWER);
BPF2_3_Start(BPF2_3_HIGHPOWER);

M8C_EnableGInt;
M8C_EnableIntMask(INT_MSK1,INT_MSK1_DBB01);


oldCardState = CARD_NOT_PRESENT;       // Initialize card insertion state
SDCard_Start();                      // initialize hardware and SDCard_lib buffers



    SDCard_Select(SDCard_ENABLE); // Select card

    cardInfo = 0;
    
    while ( ! cardInfo ) {         // Wait for card to communicate
       // initialize card, determine card type and file system type
       cardInfo = SDCard_InitCard();
    }

	
	MaxFile = SDCard_GetFileCount();

while(1){	

fp2 = SDCard_fopen(SDCard_GetFilename(Track_N),"r");      // Open file to read only data
SDCard_GetAddress(fp2,0);
SDADDRV = SDCard_Address;
FILE_LENGTH = SDCard_GetFileSize(fp2) >> 9;



SDCard_fclose(fp2);// Close file
SDCard_SetSize(512);
SDCard_Cmd(0x40 + 18,(SDADDRV & 0xFFFFFE00));	//CMD18:Open-Ended multiple block write Start
SDCard_GetR1();



while(FILE_LENGTH!=0){
SDCard_SendTxData( 0xFF );
while( ! (SDCard_bReadStatus() & SDCard_SPIM_SPI_COMPLETE ) ); //transfer complete?
Data = SDCard_bReadRxData();

	if(Data == 0xFE)      // Set check to Multiple Block Read data token
	{
	FILE_LENGTH--;	 
	for(LP_01=0;LP_01<512;LP_01++){
	
		SDCard_SendTxData( 0xFF );
		while( ! (SDCard_bReadStatus() & SDCard_SPIM_SPI_COMPLETE ) );		       
		Data = SDCard_bReadRxData(); //
		
	
		
		
		L_PCM = ADPCMDecoder(Data>>4);
		R_PCM = ADPCMDecoder2(Data);


//		DAC9_1_WriteStall(L_PCM);
/*		asm("mov	X, 0");		
		asm("mov	A, [X+3]");					//lower byte
		asm("lcall  _DAC9_1_WriteStall");
*/

//		DAC9_3_WriteStall(R_PCM);
/*		asm("mov	X, 0");
		asm("mov	A, [X+4]");					//lower byte
		asm("lcall  _DAC9_3_WriteStall");
*/		
		
/*
		PWM8_1_WritePulseWidth(R_PCM);
		PWM8_2_WritePulseWidth(L_PCM);
*/

		while(PWM_End_Flag);
		PWM16_1_WritePulseWidth(R_PCM);
		PWM16_2_WritePulseWidth(L_PCM);
		PWM_End_Flag = 1;
		}//end of for(512)
	
	SDCard_SendTxData( 0xFF );
	while( ! (SDCard_bReadStatus() & SDCard_SPIM_SPI_COMPLETE ) );//Receive CRC
	SDCard_SendTxData( 0xFF );
	while( ! (SDCard_bReadStatus() & SDCard_SPIM_SPI_COMPLETE ) );//Receive CRC

	}//endif
//	PRT0DR = port_output_dat;
	port_input_dat = PRT0DR;
	if(!(port_input_dat & SW1))break;
	
	
}	//endwhile(1)
	
/*
		PWM8_1_WritePulseWidth(0x00);
		PWM8_2_WritePulseWidth(0x00);
*/
		Track_N=Track_N>=MaxFile?1:Track_N + 1;
		ADPCMDecoderInit();
		//		STOP Tran 
		for(i=0;i<100;i++){
			SDCard_SendTxData( 0xFF );
			while( ! (SDCard_bReadStatus() & SDCard_SPIM_SPI_COMPLETE ) );
		}//endfor(i=0;i<100;i++)

// inirialize SDCard module 

		SDCard_Cmd(0x40 + 12,0);	//CMD12
		//SDCard_GetR1();
		for(i=0;i<100;i++){
			SDCard_SendTxData( 0xFF );
			while( ! (SDCard_bReadStatus() & SDCard_SPIM_SPI_COMPLETE ) );
		}//endfor(i=0;i<100;i++)
		
		while(!(port_input_dat & SW1)){
		PRT0DR = port_output_dat;
		port_input_dat = PRT0DR;
		}

}	
   // SDCard_Select(SDCard_DISABLE);         // Deselect card

    



}
#pragma interrupt_handler PWM16_1_INT
void PWM16_1_INT(void)
{
PWM_End_Flag = 0;//0:Go
}

