;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: PWM8_1.inc
;;   Version: 2.5, Updated on 2009/5/7 at 21:11:45
;;  Generated by PSoC Designer 5.0.423.0
;;
;;  DESCRIPTION: Assembler declarations for the PWM8 user module interface
;;               for the 22/24/27/29xxx PSoC family of devices
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2000-2004. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for PWM8_1 API's.
;--------------------------------------------------

PWM8_1_CONTROL_REG_START_BIT:              equ 0x01    ; Control register start bit
PWM8_1_INT_REG:                            equ 0x0e1
PWM8_1_INT_MASK:                           equ 0x40


;--------------------------------------------------
; Constants for PWM8_1 user defined values
;--------------------------------------------------

PWM8_1_PERIOD:                             equ 0x3f
PWM8_1_PULSE_WIDTH:                        equ 0x1f


;--------------------------------------------------
; Register Address Constants for PWM8_1
;--------------------------------------------------

PWM8_1_COUNTER_REG:                    equ 0x38   ; DR0 Count register
PWM8_1_PERIOD_REG:                     equ 0x39   ; DR1 Period register
PWM8_1_COMPARE_REG:                    equ 0x3a   ; DR2 Compare register
PWM8_1_CONTROL_REG:                    equ 0x3b   ; Control register
PWM8_1_FUNC_REG:                       equ 0x38   ; Function register
PWM8_1_INPUT_REG:                      equ 0x39   ; Input register
PWM8_1_OUTPUT_REG:                     equ 0x3a   ; Output register


;--------------------------------------------------
; PWM8_1 Macro 'Functions'
;--------------------------------------------------

   macro PWM8_1_Start_M
   or    reg[PWM8_1_CONTROL_REG],  PWM8_1_CONTROL_REG_START_BIT
   endm

   macro PWM8_1_Stop_M
   and   reg[PWM8_1_CONTROL_REG], ~PWM8_1_CONTROL_REG_START_BIT
   endm

   macro PWM8_1_EnableInt_M
   M8C_EnableIntMask PWM8_1_INT_REG, PWM8_1_INT_MASK
   endm

   macro PWM8_1_DisableInt_M
   M8C_DisableIntMask PWM8_1_INT_REG, PWM8_1_INT_MASK
   endm


; end of file PWM8_1.inc
