;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: BPF2_3.asm
;;   Version: 5.5, Updated on 2009/5/7 at 21:8:38
;;  Generated by PSoC Designer 5.0.423.0
;;
;;  DESCRIPTION: Asm source for 2 Pole Switched Capacitor Band Pass Filter
;;
;;  NOTE: User Module APIs conform to the fastcall16 convention for marshalling
;;        arguments and observe the associated "Registers are volatile" policy.
;;        This means it is the caller's responsibility to preserve any values
;;        in the X and A registers that are still needed after the API functions
;;        returns. For Large Memory Model devices it is also the caller's 
;;        responsibility to perserve any value in the CUR_PP, IDX_PP, MVR_PP and 
;;        MVW_PP registers. Even though some of these registers may not be modified
;;        now, there is no guarantee that will remain the case in future releases.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2001-2003. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"
include "memory.inc"
include "BPF2_3.inc"


;-----------------------------------------------
;  Global Symbols
;-----------------------------------------------
export  BPF2_3_Start
export _BPF2_3_Start
export  BPF2_3_SetPower
export _BPF2_3_SetPower

export  BPF2_3_SetC1
export _BPF2_3_SetC1
export  BPF2_3_SetC2
export _BPF2_3_SetC2
export  BPF2_3_SetC3
export _BPF2_3_SetC3
export  BPF2_3_SetC4
export _BPF2_3_SetC4
export  BPF2_3_SetCA
export _BPF2_3_SetCA
export  BPF2_3_SetCB
export _BPF2_3_SetCB
export  BPF2_3_SetPolarity
export _BPF2_3_SetPolarity

export  BPF2_3_Stop
export _BPF2_3_Stop


;-----------------------------------------------
; Variable Allocation
;-----------------------------------------------
AREA bss (RAM,REL)



;-----------------------------------------------
;  EQUATES
;-----------------------------------------------
bPOWERMASK:          equ   03h         ; Power field mask for CR3
BPF_CNUMMASK:        equ   1fh         ; Mask for A, B & C Caps
BPF_CFBMASK:         equ   80h         ; Mask for Feedback Caps
BPF_POLARITYMASK:    equ   20h         ; Mask of Asign field for CR0


AREA UserModules (ROM,REL)
;-----------------------------------------------------------------------------
;  FUNCTION NAME: BPF2_3_Start
;
;  DESCRIPTION: Applies power setting to the module's PSoC blocks
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:    A register contains the power setting (constant)
;  RETURNS:      Nothing
;  SIDE EFFECTS: 
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;

 BPF2_3_Start:
_BPF2_3_Start:
 BPF2_3_SetPower:
_BPF2_3_SetPower:
    RAM_PROLOGUE RAM_USE_CLASS_2
    and A, bPOWERMASK                        ; mask A to protect unchanged bits
    mov X, SP                                ; define temp store location

    push A                                   ; put power value in temp store
    mov A, reg[BPF2_3_FLIN_CR3]    ; read power value
    and A, ~bPOWERMASK                       ; clear power bits in A
    or  A, [X]                               ; combine power value with balance of reg.
    mov reg[BPF2_3_FLIN_CR3], A    ; move complete value back to register

    mov A, reg[BPF2_3_FLFB_CR3]    ; read power value
    and A, ~bPOWERMASK                       ; clear power bits in A
    or  A, [X]                               ; combine power value with balance of reg.
    mov reg[BPF2_3_FLFB_CR3], A    ; move complete value back to register
    pop A
    RAM_EPILOGUE RAM_USE_CLASS_2
    ret

;-----------------------------------------------------------------------------
;  FUNCTION NAME: BPF2_3_SetCn, n=1..4
;
;  DESCRIPTION:   Alters the filter transfer function by modifying the value
;                 of the capacitors (defined in BPF2_3.inc)
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:    The A register contains a non-negative integer less than 32
;  RETURNS:
;  SIDE EFFECTS: 
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 BPF2_3_SetC1:
_BPF2_3_SetC1:
    RAM_PROLOGUE RAM_USE_CLASS_2
    and A, BPF_CNUMMASK                      ; mask A to protect unchanged bits
    mov X, SP                                ; define temp store location
    push A                                   ; put C1 value in temp store
    mov A, reg[BPF2_3_FILT_C1_REG] ; read current C1
    and A, ~BPF_CNUMMASK                     ; clear C1 bits in A
    or  A, [X]                               ; combine C1 value with balance of reg.
    mov reg[BPF2_3_FILT_C1_REG], A ; move complete value back to register
    pop  A
    RAM_EPILOGUE RAM_USE_CLASS_2
    ret

 BPF2_3_SetC2:
_BPF2_3_SetC2:
    RAM_PROLOGUE RAM_USE_CLASS_2
    and A, BPF_CNUMMASK                      ; mask A to protect unchanged bits
    mov X, SP                                ; define temp store location
    push A                                   ; put C2 value in temp store
    mov A, reg[BPF2_3_FILT_C2_REG] ; read current C2
    and A, ~BPF_CNUMMASK                     ; clear C2 bits in A
    or  A, [X]                               ; combine C2 value with balance of reg.
    mov reg[BPF2_3_FILT_C2_REG], A ; move complete value back to register
    pop A
    RAM_EPILOGUE RAM_USE_CLASS_2
    ret

 BPF2_3_SetC3:
_BPF2_3_SetC3:
    RAM_PROLOGUE RAM_USE_CLASS_2
    and A, BPF_CNUMMASK                      ; mask A to protect unchanged bits
    mov X, SP                                ; define temp store location
    push A                                   ; put C3 value in temp store
    mov A, reg[BPF2_3_FILT_C3_REG] ; read current C3
    and A, ~BPF_CNUMMASK                     ; clear C3 bits in A
    or  A, [X]                               ; combine C3 value with balance of reg.
    mov reg[BPF2_3_FILT_C3_REG], A ; move complete value back to register
    pop A
    RAM_EPILOGUE RAM_USE_CLASS_2
    ret

 BPF2_3_SetC4:
_BPF2_3_SetC4:
    RAM_PROLOGUE RAM_USE_CLASS_2
    and A, BPF_CNUMMASK                      ; mask A to protect unchanged bits
    mov X, SP                                ; define temp store location
    push A                                   ; put C4 value in temp store
    mov A, reg[BPF2_3_FILT_C4_REG] ; read current C4
    and A, ~BPF_CNUMMASK                     ; clear C4 bits in A
    or  A, [X]                               ; combine C4 value with balance of reg.
    mov reg[BPF2_3_FILT_C4_REG], A ; move complete value back to register
    pop A
    RAM_EPILOGUE RAM_USE_CLASS_2
    ret


;-----------------------------------------------------------------------------
;  FUNCTION NAME: BPF2_3_SetCA
;            and  BPF2_3_SetCB
;
;  DESCRIPTION:   Alters the filter transfer function by modifying the value
;                 of the op-amp feedback capacitors (see BPF2_3.inc)
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:    The A register contains one of the BPF2_3_FEEDBACK
;                  constants defined in BPF2_3.inc
;  RETURNS:      Nothing.
;  SIDE EFFECTS: 
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 BPF2_3_SetCA:
_BPF2_3_SetCA:
    RAM_PROLOGUE RAM_USE_CLASS_1
    cmp   A, BPF2_3_FEEDBACK_32    ; Change Feedback to 32 units?
    jz    .SetCAto32                         ;    Yes, go make it so
                                             ;     No, clear it to 16 units...
    and   reg[BPF2_3_FILT_CA_REG], ~BPF_CFBMASK
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret
.SetCAto32:
    or    reg[BPF2_3_FILT_CA_REG],  BPF_CFBMASK
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret


 BPF2_3_SetCB:
_BPF2_3_SetCB:
    RAM_PROLOGUE RAM_USE_CLASS_1
    cmp   A, BPF2_3_FEEDBACK_32    ; Change Feedback to 32 units?
    jz    .SetCAto32                         ;    Yes, go make it so
                                             ;     No, clear it to 16 units...
    and   reg[BPF2_3_FILT_CB_REG], ~BPF_CFBMASK
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret
.SetCAto32:
    or    reg[BPF2_3_FILT_CB_REG],  BPF_CFBMASK
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret

;-----------------------------------------------------------------------------
;  FUNCTION NAME: BPF2_3_SetPolarity
;
;  DESCRIPTION:   Alters the output polarity of the data by altering the
;                 input polarity at FLIN
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:    The A register contains one of the BPF2_3_POLARITY
;                  constants defined in BPF2_3.inc
;  RETURNS:      Nothing.
;  SIDE EFFECTS: 
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 BPF2_3_SetPolarity:
_BPF2_3_SetPolarity:
    RAM_PROLOGUE RAM_USE_CLASS_1
    cmp   A, BPF2_3_POLARITY_NON_INVERTING ; Should the output be non-inverting?
    jz    .SetPoltoNonInv                         ;    Yes, go make it so
                                                  ;    No, then set it to Inverting...
    or    reg[BPF2_3_FLIN_CR0], BPF_POLARITYMASK
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret
.SetPoltoNonInv:
    and   reg[BPF2_3_FLIN_CR0], ~BPF_POLARITYMASK
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret


;-----------------------------------------------------------------------------
;  FUNCTION NAME: BPF2_3_Stop
;
;  DESCRIPTION: Cuts power to the user module.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:     None
;  RETURNS:       Nothing
;  SIDE EFFECTS: 
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 BPF2_3_Stop:
_BPF2_3_Stop:
    RAM_PROLOGUE RAM_USE_CLASS_1

    and reg[BPF2_3_FLIN_CR3], ~bPOWERMASK
    and reg[BPF2_3_FLFB_CR3], ~bPOWERMASK
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret


; End of File BPF2_3.asm
