;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: DAC9_1.inc
;;   Version: 2.2, Updated on 2009/5/7 at 21:9:55
;;  Generated by PSoC Designer 5.0.423.0
;;
;;  DESCRIPTION:  Assembler declarations for the DAC9 user module interface
;;                for the 22/24/25/26/27/29xxx PSoC family of devices.
;;
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2000-2004. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"

;--------------------------------------------------
; Constants for DAC9_1 API's
;--------------------------------------------------
DAC9_1_OFF:              equ 00h
DAC9_1_LOWPOWER:         equ 01h
DAC9_1_MEDPOWER:         equ 02h
DAC9_1_HIGHPOWER:        equ 03h
DAC9_1_FULLPOWER:        equ 03h

DAC9_1_LSB_CR0:          equ 90h
DAC9_1_LSB_CR1:          equ 91h
DAC9_1_LSB_CR2:          equ 92h
DAC9_1_LSB_CR3:          equ 93h
DAC9_1_MSB_CR0:          equ 80h
DAC9_1_MSB_CR1:          equ 81h
DAC9_1_MSB_CR2:          equ 82h
DAC9_1_MSB_CR3:          equ 83h

DAC9_1_OffsetBinary:     equ 04h
DAC9_1_TwosComplement:   equ 02h
DAC9_1_SignAndMagnitude: equ 01h
DAC9_1_RawRegister:      equ 00h

DAC9_1_DATAFORMAT:       equ 7h
DAC9_1_OFFSETBINARY:     equ DAC9_1_DATAFORMAT & DAC9_1_OffsetBinary
DAC9_1_TWOSCOMPLEMENT:   equ DAC9_1_DATAFORMAT & DAC9_1_TwosComplement
DAC9_1_SIGNANDMAGNITUDE: equ DAC9_1_DATAFORMAT & DAC9_1_SignAndMagnitude

DAC9_1_PHASE_Normal:     equ 0
DAC9_1_PHASE_Swapped:    equ 1

DAC9_1_PHASE_SWAP:       equ DAC9_1_PHASE_Normal

IF DAC9_1_PHASE_SWAP
    DAC9_1_CR0_HIBITS:   equ C0h
ELSE
    DAC9_1_CR0_HIBITS:   equ 80h
ENDIF

;--------------------------------------------------
; Register Address Constants for DAC9_1
;--------------------------------------------------
DAC9_1_LSB_CR0: equ 90h                          ; LSB SC Block Control Register 0
DAC9_1_LSB_CR1: equ 91h                          ; LSB SC Block Control Register 1
DAC9_1_LSB_CR2: equ 92h                          ; LSB SC Block Control Register 2
DAC9_1_LSB_CR3: equ 93h                          ; LSB SC Block Control Register 3

DAC9_1_MSB_CR0: equ 80h                          ; MSB SC Block Control Register 0
DAC9_1_MSB_CR1: equ 81h                          ; MSB SC Block Control Register 1
DAC9_1_MSB_CR2: equ 82h                          ; MSB SC Block Control Register 2
DAC9_1_MSB_CR3: equ 83h                          ; MSB SC Block Control Register 3

; end of file DAC9_1.inc
