;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: DAC9_1.asm
;;   Version: 2.2, Updated on 2009/5/7 at 21:9:55
;;  Generated by PSoC Designer 5.0.423.0
;;
;;  DESCRIPTION: DAC9 User Module software inplementation file for the
;;               22/24/25/26/27/29xxx PSoC family of devices.
;;
;;  NOTE: User Module APIs conform to the fastcall16 convention for marshalling
;;        arguments and observe the associated "Registers are volatile" policy.
;;        This means it is the caller's responsibility to preserve any values
;;        in the X and A registers that are still needed after the API functions
;;        returns. For Large Memory Model devices it is also the caller's 
;;        responsibility to perserve any value in the CUR_PP, IDX_PP, MVR_PP and 
;;        MVW_PP registers. Even though some of these registers may not be modified
;;        now, there is no guarantee that will remain the case in future releases.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2000-2004. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "DAC9_1.inc"
include "m8c.inc"
include "memory.inc"

;-----------------------------------------------
;  Global Symbols
;-----------------------------------------------
export  DAC9_1_Start
export _DAC9_1_Start
export  DAC9_1_SetPower
export _DAC9_1_SetPower

export  DAC9_1_WriteBlind
export _DAC9_1_WriteBlind
export  DAC9_1_WriteBlind2B
export _DAC9_1_WriteBlind2B

export  DAC9_1_WriteStall
export _DAC9_1_WriteStall
export  DAC9_1_WriteStall2B
export _DAC9_1_WriteStall2B

export  DAC9_1_Stop
export _DAC9_1_Stop

;; -----------------------------------------------------------------
;;                         Register Definitions
;; -----------------------------------------------------------------
;;
;; Uses 2 Switched Cap Blocks, LSB and MSB, configured as shown below.
;; This API depends on knowing the exact personalization of CR0
;; and CR3 bitfields for time efficiency.
;;
;; * For a Mask/Val pair this simply indicates that the value is
;;   determined by the user either through config-time parameteriza-
;;   tion or run-time manipulation.
;;
;; Setting for output=AGND to OBUS when LSB in ASA10 and MSB in ASB20:
;;     LSB.CR0=80  MSB.CR0=80
;;     LSB.CR1=40  MSB.CR1=81
;;     LSB.CR2=20  MSB.CR2=A0
;;     LSB.CR3=33  MSB.CR3=3B
;;
;;  BIT FIELD            Mask/Val Function
;;  -----------------    -------- --------------------
;;  LSB.CR0.FCap         80/1  Feedback cap size 32
;;  LSB.CR0.ClockPhase   40/0  Normal phase
;;  LSB.CR0.ASign        20/*  User parameter
;;  LSB.CR0.ACap         1F/*  User parameter
;;
;;  LSB.CR1.ACMux        E0/2  (SCA) A:VRef High, C:Don't Care
;;  LSB.CR1.BCap         1F/0  Prune B-input branch
;;
;;  LSB.CR2.AnalogBus    80/*  User Parameter: Output Bus Enable
;;  LSB.CR2.CmpBus       40/0  Comparator Bus Disabled
;;  LSB.CR2.AutoZero     20/1  Auto-Zero enabled on internal Phi 1
;;  LSB.CR2.CCap         1F/0  Prune C-input branch
;;
;;  LSB.CR3.ARefSelect   C0/0  Use AGND (to invert)
;;  LSB.CR3.FSW1         20/1  Feedback Cap Used
;;  LSB.CR3.FSW0         10/1  Feedback Cap Grounded for AZ
;;  LSB.CR3.BMux         0C/0  (SCA) Don't Care - this branch pruned
;;  LSB.CR3.PWR          03/*  User Parameter: Power; default=OFF
;;
;;  MSB.CR0.FCap         80/1  Feedback cap size 32
;;  MSB.CR0.ClockPhase   40/0  Normal phase
;;  MSB.CR0.ASign        20/*  User parameter
;;  MSB.CR0.ACap         1F/*  User parameter
;;
;;  MSB.CR1.AMux         E0/4  (SCB) VRef High
;;  MSB.CR1.BCap         1F/1  Subrange LSB block output by BCap/FCap (1/32)
;;
;;  MSB.CR2.AnalogBus    80/*  User Parameter: Output Bus Enable
;;  MSB.CR2.CmpBus       40/0  Comparator Bus Disable
;;  MSB.CR2.AutoZero     20/1  Auto-Zero enabled on internal Phi 1
;;  MSB.CR2.CCap         1F/0  Prune C-input branch
;;
;;  MSB.CR3.ARefSelect   C0/0  Use AGND (to invert)
;;  MSB.CR3.FSW1         20/1  Feedback Cap Used
;;  MSB.CR3.FSW2         10/1  Feedback Cap Grounded for AZ
;;  MSB.CR3.BSW          08/0  (SCB)    why is this cont time instead of phi2??
;;  MSB.CR3.BMux         04/?  (SCB) LSB block output; determined by placement
;;  MSB.CR3.PWR          03/*  User Parameter: Power, default=OFF

;-----------------------------------------------
;  Constant Definitions
;-----------------------------------------------
iOFFSET:   equ 255              ; Conversion term for offset binary to 2's C
bPWRMASK:  equ 03h              ; Power bitfield in Switched Cap CR3 reg
bCR3:      equ 30h              ; Except for power bits, CR3 always looks like
                                ; this regardless of SC block type or location.
bSMMASK:   equ 3Fh              ; Sign and Magnitude bits mask
bSIGNMASK: equ 20h              ; Sign bit mask
bMAGMASK:  equ 1Fh              ; Magnitude bits mask
bHIGHBITS: equ 80h              ; Setting for FCap and ClockPhase
bHBMASK:   equ C0h              ; Mask for FCap and ClockPhase


;;---------------------------
        macro Stall
;;---------------------------
        mov reg[ASY_CR], 1
        endm

;;---------------------------
        macro UnStall
;;---------------------------
        mov reg[ASY_CR], 0
        endm

  AREA UserModules (ROM, REL)

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: DAC9_1_Start
;  FUNCTION NAME: DAC9_1_SetPower
;
;  DESCRIPTION:
;    Applies power setting to the module's analog PSoC blocks.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;    A contains the power setting 0=Off, 1=Low, 2=Med, 3=Full.
;
;  RETURNS:  none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 DAC9_1_Start:
_DAC9_1_Start:
 DAC9_1_SetPower:
_DAC9_1_SetPower:
    RAM_PROLOGUE RAM_USE_CLASS_2 
    and   A, bPWRMASK       ; trim input to bits of interest
    mov   X, SP             ; Set stack frame pointer
    push  A
    ;; read CR3 registers, modify power bits & write back
    mov   A, reg[DAC9_1_MSB_CR3]
    and   a, ~bPWRMASK      ; clear old setting
    or    A, [X]            ; set power in MSB register image
    mov   reg[DAC9_1_MSB_CR3], A
    mov   A, reg[DAC9_1_LSB_CR3]
    and   a, ~bPWRMASK      ; clear old setting
    or    A, [X]            ; set power in LSB register image
    mov   reg[DAC9_1_LSB_CR3], A
    pop   A
    RAM_EPILOGUE RAM_USE_CLASS_2 
    ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: DAC9_1_WriteBlind
;  FUNCTION NAME: DAC9_1_WriteBlind2B
;
;  DESCRIPTION:
;    Modify the DAC's update value without worrying about the clocks.
;    Lowest overhead, but may cause glitches on the output.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;     A contains the update value if data format is offset binary or
;     For offset binary format: A contains the low byte; X the high byte.
;     For twos complement format: A contains the low byte; X the high byte.
;     For two-byte sign-and-magnitude format:
;      A contains the LSB as 00smmmmm; X contains the MSB as 00tmmm00,
;      where t=s\ (the inverted sign).
;
;  RETURNS:
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 DAC9_1_WriteBlind:
_DAC9_1_WriteBlind:

  RAM_PROLOGUE RAM_USE_CLASS_2 
  IF DAC9_1_OFFSETBINARY
    ;; Data is an unsigned byte value in [0..510] (511 unique values).
    ;; Following converts it to 2's complement:
    sub   A, iOFFSET
    swap  A, X                  ;  A <- upper, X <- lower
    sbb   A, 0
    swap  A, X                  ;  A <- lower, X <- upper
  ENDIF

  IF DAC9_1_OFFSETBINARY | DAC9_1_TWOSCOMPLEMENT
    swap  A, X                  ;  A <- upper, X <- lower
    push A                      ; Save Sign on stack - referenced using [X-N]
                                ; Sign is either FFh or 00h
    dec  A                      ; set or clear Carry Flag
                                ; A is now FEh(CF=0) or FFh(CF=1)
    mov  A,X                    ; MSB: 76543210
    jc   BlindAdjustCycles
    cpl  A                      ; change negative magnitude to positive
        inc  A                      ; offset for twos complement
        jmp  BlindMagSet
BlindAdjustCycles:
        cpl  A                                          ; make cycles used for positive same as
        cpl  A                      ; cycles used for negative
        jmp  BlindMagSet
BlindMagSet:
    push A                      ; MSB: 76543210 (mag)
    asr  A                      ; MSB: 77654321
    asr  A                      ; MSB: 77765432
    asr  A                      ; MSB: 77776543
    and  A,bMAGMASK             ; MSB: 00076543
    mov  X,SP
    and  [X-2],bSIGNMASK
    or   A,[X-2]                ; MSB: 00s76543
    mov  X,A                    ; MSB
    pop  A                      ; LSB: 76543210 (mag)
    push X                      ; MSB
    asl  A                      ; LSB: 65432100
    asl  A                      ; LSB: 54321000
    and  A,bMAGMASK             ; LSB: 00021000
    mov  X,SP
    or   A,[X-2]                ; LSB: 00s21000
    xor  A,bSIGNMASK            ; LSB: 00t21000
                                ; LSB in A
    pop  X                      ; MSB in X
    add  SP, -1                 ; clean up stack - from saving the sign

  ENDIF

 DAC9_1_WriteBlind2B:
_DAC9_1_WriteBlind2B:
; IF DAC9_1_SIGNANDMAGNITUDE
    or   A,bHIGHBITS            ; LSB: 10t21000
    swap A,X                    ; LSB in X, MSB in A
    or   A,bHIGHBITS            ; MSB: 10s76543
    mov  reg[DAC9_1_MSB_CR0],A
    mov  A,X                    ; LSB in A
    mov  reg[DAC9_1_LSB_CR0],A
; ENDIF

  RAM_EPILOGUE RAM_USE_CLASS_2 
  ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: DAC9_1_WriteStall
;  FUNCTION NAME: DAC9_1_WriteStall2B
;
;  DESCRIPTION:
;    Modify the DAC's update value, stalling the CPU if necessary.
;    This routine should be used with faster analog clocks or when the
;    effect of prolonging interrupt latencies can be safely tolerated.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;    A contains the update value if data format is offset binary or
;    For offset binary format: A contains the low byte; X the high byte.
;    For twos complement format: A contains the low byte; X the high byte.
;    For two-byte sign-and-magnitude format:
;     A contains the LSB as 00smmmmm; X contains the MSB as 00tmmm00,
;     where t=s\ (the inverted sign).
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 DAC9_1_WriteStall:
_DAC9_1_WriteStall:

  RAM_PROLOGUE RAM_USE_CLASS_2 
  IF DAC9_1_OFFSETBINARY
    ;; Data is an unsigned byte value in [0..510] (511 unique values).
    ;; Following converts it to 2's complement:
    sub   A, iOFFSET
    swap  A, X                  ;  A <- upper, X <- lower
    sbb   A, 0
    swap  A, X                  ;  A <- lower, X <- upper
  ENDIF

  IF DAC9_1_OFFSETBINARY | DAC9_1_TWOSCOMPLEMENT
    swap  A, X                  ;  A <- upper, X <- lower
    push A                      ; Save Sign on stack - referenced via [X-N]
                                ; Sign is either FFh or 00h
    dec  A                      ; set or clear Carry Flag
                                ; A is now FEh(CF=0) or FFh(CF=1)
    mov  A,X                    ; MSB: 76543210
    jc   StallAdjustCycles
    cpl  A                      ; change negative magnitude to positive
        inc  A                      ; offset for twos complement
        jmp  StallMagSet
StallAdjustCycles:
        cpl  A                                          ; make cycles used for positive same as
        cpl  A                      ; cycles used for negative
        jmp  StallMagSet
StallMagSet:
        push A                      ; MSB: 76543210 (mag)
    asr  A                      ; MSB: 77654321
    asr  A                      ; MSB: 77765432
    asr  A                      ; MSB: 77776543
    and  A,bMAGMASK             ; MSB: 00076543
    mov  X,SP
    and  [X-2],bSIGNMASK
    or   A,[X-2]                ; MSB: 00s76543
    mov  X,A                    ; MSB

    pop  A                      ; LSB: 76543210 (mag)
    push X                      ; MSB

    asl  A                      ; LSB: 65432100
    asl  A                      ; LSB: 54321000
    and  A,bMAGMASK             ; LSB: 00021000
    mov  X,SP
    or   A,[X-2]                ; LSB: 00s21000
    xor  A,bSIGNMASK            ; LSB: 00t21000
                                ; LSB in A
    pop  X                      ; MSB in X
    add  SP, -1                 ; clean up stack - from saving the sign
  ENDIF

 DAC9_1_WriteStall2B:
_DAC9_1_WriteStall2B:
; IF DAC9_1_SIGNANDMAGNITUDE
    or   A,bHIGHBITS            ; LSB: 10t21000
    swap A,X                    ; LSB in X, MSB in A
    or   A,bHIGHBITS            ; MSB: 10s76543
    M8C_Stall
    mov  reg[DAC9_1_MSB_CR0],A
    M8C_Unstall
    mov  A,X                    ; LSB in A
    mov  reg[DAC9_1_LSB_CR0],A
; ENDIF

  RAM_EPILOGUE RAM_USE_CLASS_2 
  ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: DAC9_1_Stop
;
;  DESCRIPTION:
;    Cuts power to the user module.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 DAC9_1_Stop:
_DAC9_1_Stop:
    RAM_PROLOGUE RAM_USE_CLASS_1 
    and  reg[DAC9_1_MSB_CR3], ~bPWRMASK
    and  reg[DAC9_1_LSB_CR3], ~bPWRMASK
    RAM_EPILOGUE RAM_USE_CLASS_1 
    ret
.ENDSECTION

; End of File DAC9_1.asm
