/*******************************************************************************
 * Copyright (c) 2003, Michael Bartl
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Created on 26.05.2003
 *******************************************************************************/

package viPlugin.test;

import junit.framework.TestCase;

import org.eclipse.jface.text.IRegion;

import viPlugin.TextModificator;

/**
 * @author Michael Bartl
 */
public class TextModificatorTest extends TestCase {
	private TextModificator t;
	private final String simpleString =
		"This is a simple.three()  line>string (  ) become\r\n"
			+ "To test the functionality of\r\n"
			+ "the TextModification class";

	/**
	 * Constructor for TextModificatorTest.
	 * 
	 * @param arg0
	 */
	public TextModificatorTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(TextModificatorTest.class);
	}

	protected void setUp() throws Exception {
		SharedTestResources.setConfiguredTextModificator(simpleString);
		t = TextModificator.getInstance();
	}

	final public void testCursorLeft() {
		t.cursorToLineEnd();
		int cursorPos = t.cursorLeft(3);
		assertEquals(simpleString.indexOf("ome"), cursorPos);
		cursorPos = t.cursorLeft(100);
		IRegion line = t.getLine();
		assertEquals(0, cursorPos);
	}

	final public void testCursorRight() {
		int cursorPos = t.cursorRight(3);
		assertEquals(simpleString.indexOf("s is a"), cursorPos);
		cursorPos = t.cursorRight(100);
		assertEquals(simpleString.indexOf("\r\nTo test"), cursorPos);
	}

	final public void testCursorToLine() {
		int cursorPos = t.cursorToLine(0, true);
		assertEquals(0, cursorPos);
		cursorPos = t.cursorToLine(1, true);
		assertEquals(simpleString.indexOf("To test"), cursorPos);
		cursorPos = t.cursorToLine(3, true);
		assertEquals(
			simpleString.indexOf("the TextModification class"),
			cursorPos);
		cursorPos = t.cursorToLine(100, true);
		assertEquals(
			simpleString.indexOf("the TextModification class"),
			cursorPos);
	}

/* TODO: fix test
	final public void testCursorWord() {
		int cursorPos = t.cursorWord(3);
		assertEquals(simpleString.indexOf("simple.three()"), cursorPos);
		cursorPos = t.cursorWord(1);
		assertEquals(simpleString.indexOf(".three()"), cursorPos);
		cursorPos = t.cursorWord(1);
		assertEquals(simpleString.indexOf("three()"), cursorPos);
		cursorPos = t.cursorWord(1);
		assertEquals(simpleString.indexOf("() line"), cursorPos);
		cursorPos = t.cursorWord(1);
		assertEquals(simpleString.indexOf("line>string"), cursorPos);
		cursorPos = t.cursorWord(2);
		assertEquals(simpleString.indexOf("string ( )"), cursorPos);
		cursorPos = t.cursorWord(1);
		assertEquals(simpleString.indexOf("( ) become"), cursorPos);
		cursorPos = t.cursorWord(1);
		assertEquals(simpleString.indexOf(") become"), cursorPos);
	}
	*/

	final public void testCursorWordBack() {
		/*
		 * TODO: fix int cursorPos = tm.cursorToLineEnd(); cursorPos =
		 * tm.cursorWordBack(1); assertEquals(simpleString.indexOf("become"),
		 * cursorPos); cursorPos = tm.cursorWordBack(1);
		 * assertEquals(simpleString.indexOf(") become"), cursorPos); cursorPos =
		 * tm.cursorWordBack(1); assertEquals(simpleString.indexOf("( )
		 * become"), cursorPos); cursorPos = tm.cursorWordBack(1);
		 * assertEquals(simpleString.indexOf("string ( )"), cursorPos);
		 * cursorPos = tm.cursorWordBack(1);
		 * assertEquals(simpleString.indexOf(">string"), cursorPos); cursorPos =
		 * tm.cursorWordBack(2); assertEquals(simpleString.indexOf("()
		 * line>string"), cursorPos);
		 */
	}

	final public void testCursorWordEnd() {
		int cursorPos = t.cursorWordEnd(2);
		assertEquals(simpleString.indexOf("s a simple"), cursorPos);
		cursorPos = t.cursorWordEnd(1);
		assertEquals(simpleString.indexOf("a simple.three()"), cursorPos);
		cursorPos = t.cursorWordEnd(1);
		assertEquals(simpleString.indexOf("e.three()"), cursorPos);
		cursorPos = t.cursorWordEnd(1);
		assertEquals(simpleString.indexOf(".three()"), cursorPos);
		cursorPos = t.cursorWordEnd(1);
		assertEquals(simpleString.indexOf("e()  line"), cursorPos);
		cursorPos = t.cursorWordEnd(1);
		assertEquals(simpleString.indexOf(")  line"), cursorPos);
		cursorPos = t.cursorWordEnd(1);
		assertEquals(simpleString.indexOf("e>string"), cursorPos);
		cursorPos = t.cursorWordEnd(2);
		assertEquals(simpleString.indexOf("g (  ) become"), cursorPos);
		cursorPos = t.cursorWordEnd(1);
		assertEquals(simpleString.indexOf("(  ) become"), cursorPos);
		cursorPos = t.cursorWordEnd(1);
		assertEquals(simpleString.indexOf(") become"), cursorPos);
	}

/* TODO: fix test
	final public void testCursorToLastLine() {
		int cursorPos = t.cursorToLastLine();
		assertEquals(
			simpleString.indexOf("the TextModification class"),
			cursorPos);
	}
	*/

	// TODO: update TextModificatorTest to use CommandActions
	/*
	 * final public void testDeleteCharacterSelection() { TextSelection
	 * selection = new TextSelection(doc, 0, 10); tm.setSelection(selection);
	 * tm.deleteSelection(true); String newString = simpleString.substring(10);
	 * assertEquals(newString, doc.get()); }
	 * 
	 * final public void testDeleteLineSelection1() { tm.cursorToLastLine();
	 * tm.selectLines(1, true); tm.deleteSelection(true); String newString =
	 * simpleString.substring(0, simpleString.indexOf("the TextModification"));
	 * assertEquals(newString, doc.get()); }
	 * 
	 * final public void testDeleteLineSelection2() { tm.cursorToLastLine();
	 * tm.insertStringBelow("xxx2"); String text = doc.get(); String newString =
	 * text.substring(0, text.indexOf("xxx2")); tm.cursorToLastLine();
	 * tm.selectLines(1, true); tm.deleteSelection(true);
	 * assertEquals(newString, doc.get()); }
	 * 
	 * final public void testYankSelection() { TextSelection selection = new
	 * TextSelection(doc, 0, 10); tm.setSelection(selection);
	 * tm.yankSelection(); String newString = simpleString.substring(0, 10);
	 * assertEquals(newString, tm.getYankBuffer().getText()); }
	 */

	final public void testPaste() {
		//TODO Implement paste().
	}

	final public void testSearchNext() {
		//TODO Implement searchNext().
	}

	final public void testSearchPrevious() {
		//TODO Implement searchPrevious().
	}

	final public void testSearch() {
		//TODO Implement search().
	}

	final public void testSearchCurrentWord() {
		//TODO Implement searchCurrentWord().
	}

	final public void testSearchCurrentWordBackwards() {
		//TODO Implement searchCurrentWordBackwards().
	}

	/**
	 * Tests the functionality of the getNextWord() method.
	 * 
	 * @throws Exception
	 *             if there was a problem running the test.
	 */
	final public void testGetNextWord() throws Exception {
		// Test single word endings
		String s0 =
			"Everyone thinks of changing the world, but no "
				+ "one thinks of changing himself.";
		int wordSum = 0;
		int wordIdx = 0;
		do {
			wordIdx = t.getNextWord(s0, wordIdx);
			++wordSum;
		} while (wordIdx < s0.length() - 1);
		assertEquals(14, wordSum);

		// Test multiple series of word endings
		String s1 = "f(x) = mx + b";
		wordSum = 0;
		wordIdx = 0;
		do {
			wordIdx = t.getNextWord(s1, wordIdx);
			++wordSum;
		} while (wordIdx < s1.length() - 1);
		assertEquals(7, wordSum);

		// Test no word endings
		String s2 = "Supercalifragalisticexpialadocious";
		assertEquals(s2.length() - 1, t.getNextWord(s2, 0));

		// Test empty string behavior
		String s3 = "";
		assertEquals(0, t.getNextWord(s3, 0));
	}

	/**
	 * Tests the functionality of the getPreviousWord() method.
	 * 
	 * @throws Exception
	 *             if there was a problem running the test.
	 */
	final public void testGetPreviousWord() throws Exception {
		// TODO: Implement test.
	}

	/**
	 * Tests the functionality of the cursorToLineEnd() method.
	 * 
	 * @throws Exception
	 *             if there was a problem running the test.
	 */
	final public void testCursorToLineEnd() throws Exception {
		// TODO: Implement test.
	}
}
