package viPlugin.test;

import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

import viPlugin.TextModificator;

/**
 * Because the way JUnit works and mainly because the bad <b>temporary</b>;)
 * design of TextModificator class this class is needed if we want to run all
 * tests at once (AllTests class). Try it to know why. If you found out a safer
 * style than a Singleton, refactore tests.
 * 
 * BMK: Strangely enough, the problem with letting this class manage a
 * TextModificator singleton is that the singleton's consituent fields become
 * out of sync with the TextModificator singleton that is utilized by other,
 * non-test classes (e.g. Command class derivatives). Is this a strange JUnit
 * quirk? I wasn't aware of any parallelism in the Eclipse/JUnit combo that
 * would result in this kind of behavior...
 * 
 * Anyway, the solution is to let the singleton be managed in the actual
 * TextModificator class as usual, and let the tests configure and acquire the
 * TextModifcator singleton in the JUnit setUp() methods.
 * 
 * @author <a href="mailto:emdot@seznam.cz">Martin Krauskopf</a>
 * @version $Revision: 1.2 $ $Date: 2003/12/08 12:41:58 $
 */
class SharedTestResources {

	private static IDocument doc;

	/**
	 * Return a configured TextModificator.
	 * 
	 * @param content
	 *            the string that the returned TextModificator will represent.
	 * @param numLines
	 *            the number of logical lines in the text represented by the
	 *            returned TextModificator.
	 * @return a configured TextModificator singleton.
	 */
	public static void setConfiguredTextModificator(String content) {
		doc = new Document(content);
		TextModificator.setEmptyInstance(doc);
	}

	public static int getNumberOfLines() {
		return doc.getNumberOfLines();
	}

}
