/*******************************************************************************
 * Copyright (c) 2003, Michael Bartl
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Created on 09.01.2004
 *******************************************************************************/

package viPlugin.test;

import junit.framework.TestCase;
import viPlugin.TextModificator;
import viPlugin.commands.ReplaceString;

public class SearchReplaceTest extends TestCase {

    private TextModificator _tm;
    private final String _documentContent = "1. first second, third, ..., last\r\n"
            + "2. ffirst, ssecond, tthird, ..., llast\r\n"
            + "3. ffirst, ssecond, tthird, ..., llast\r\n"
            + "4. ffirst, ssecond, tthird, ..., llast";

    protected void setUp() throws Exception {
        SharedTestResources.setConfiguredTextModificator(_documentContent);
        _tm = TextModificator.getInstance();
    }

    // TODO: check if replacement was correct
    public void testExecute() {
        ReplaceString rs = new ReplaceString("%s/first/whatever/g");
        rs.execute();
    }
}