package viPlugin.test;

import junit.framework.TestCase;
import viPlugin.TextModificator;
import viPlugin.commands.Command;
import viPlugin.commands.motion.GoToFirstLine;
import viPlugin.commands.motion.GoToLastLine;
import viPlugin.commands.motion.MoveDown;
import viPlugin.commands.motion.MoveUp;

/**
 * Tests MotionCommand classes.
 * 
 * @author <a href="mailto:emdot@seznam.cz">Martin Krauskopf</a>
 * @version $Revision: 1.4 $ $Date: 2003/12/08 12:41:58 $
 */
public class MotionCommandsTest extends TestCase {
	private TextModificator _tm;
	private final String _documentContent =
		"1. first second, third, ..., last\r\n"
			+ "2. ffirst, ssecond, tthird, ..., llast\r\n"
			+ "3. ffirst, ssecond, tthird, ..., llast\r\n"
			+ "4. ffirst, ssecond, tthird, ..., llast";

	/**
	 * Constructor.
	 * 
	 * @param name
	 *            testName
	 */
	public MotionCommandsTest(String name) {
		super(name);
	}

	protected void setUp() throws Exception {
		SharedTestResources.setConfiguredTextModificator(_documentContent);
		_tm = TextModificator.getInstance();
	}

	public void testMoveDown() {
		// move to the first line
		Command goToFirstLine = new GoToFirstLine();
		goToFirstLine.execute();
		int pos = _tm.getLinePos();
		assertEquals(pos, 0);

		// move down two lines
		Command moveDown = new MoveDown(2);
		moveDown.execute();
		pos += 2;
		assertEquals(pos, _tm.getLinePos());

		// paranoiac check
		Command moveDown1 = new MoveDown(1);
		boolean isLastLine =
			(_tm.getLinePos() + 1) == _tm.getDocument().getNumberOfLines();
		moveDown1.execute();
		if (isLastLine) {
			assertEquals(pos, _tm.getLinePos());
		} else {
			assertEquals(++pos, _tm.getLinePos());
		}

		// move another 100000 lines down
		Command moveDown100k = new MoveDown(100000);
		moveDown100k.execute();
		assertEquals(
			_tm.getDocument().getNumberOfLines() - 1,
			_tm.getLinePos());
		assertEquals(
			"4. ffirst, ssecond, tthird, ..., llast",
			_tm.getLineText());

	}

	public void testMoveUp() {
		// move to the last line
		Command goToLastLine = new GoToLastLine();
		goToLastLine.execute();
		int pos = _tm.getLinePos();
		assertEquals(pos, _tm.getDocument().getNumberOfLines() - 1);
		assertEquals("4. ffirst, ssecond, tthird, ..., llast", _tm.getLineText());

		// move 2 lines up
		Command moveUp2 = new MoveUp(2);
		moveUp2.execute();
		pos -= 2;
		assertEquals(pos, _tm.getLinePos());

		// move another 100000 lines up
		Command moveUp100k = new MoveUp(100000);
		moveUp100k.execute();
		assertEquals(0, _tm.getLinePos());

		assertEquals("1. first second, third, ..., last", _tm.getLineText());
	}
}
