/*******************************************************************************
 * Copyright (c) 2003, Michael Bartl
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Created on 09.01.2004
 *******************************************************************************/

package viPlugin.test;

import junit.framework.TestCase;
import viPlugin.TextModificator;
import viPlugin.commands.MatchBrace;
import viPlugin.commands.search.RegExSearch;

public class MatchBraceTest extends TestCase {

    private TextModificator _tm;
    private final String _documentContent = "[ { 1{ 2 { 3 } 4 } 5 } ] ( )()";

    protected void setUp() throws Exception {
        SharedTestResources.setConfiguredTextModificator(_documentContent);
        _tm = TextModificator.getInstance();
    }

    public void testExecute() {
        if (RegExSearch.isSupported(false)) {
            
            // first brace search
            _tm.setVisualSelection(1, 1);
            MatchBrace mb = new MatchBrace();
            mb.execute();
            int pos = _tm.getCaretPosition();
            assertEquals(2, pos);
            
            // forward search with nested braces
            _tm.setVisualSelection(0, 1);
            mb = new MatchBrace();
            mb.execute();
            pos = _tm.getCaretPosition();
            assertEquals(23, pos);
            
            _tm.setVisualSelection(2, 1);
            mb = new MatchBrace();
            mb.execute();
            pos = _tm.getCaretPosition();
            assertEquals(21, pos);
            
            // backward searches
            _tm.setVisualSelection(27, 1);
            mb = new MatchBrace();
            mb.execute();
            pos = _tm.getCaretPosition();
            assertEquals(25, pos);
            
            _tm.setVisualSelection(29, 1);
            mb = new MatchBrace();
            mb.execute();
            pos = _tm.getCaretPosition();
            assertEquals(28, pos);
            
            // backward search with nested braces
            _tm.setVisualSelection(17, 1);
            mb = new MatchBrace();
            mb.execute();
            pos = _tm.getCaretPosition();
            assertEquals(5, pos);
        }
    }
}