package viPlugin.test;

import junit.framework.TestCase;
import viPlugin.TextModificator;
import viPlugin.commands.Command;
import viPlugin.commands.delete.DeleteWordForward;
import viPlugin.commands.motion.GoToFirstLine;

/**
 * Tests detele commands.
 * 
 * @author <a href="mailto:emdot@seznam.cz">Martin Krauskopf</a>
 * @version $Revision: 1.4 $ $Date: 2003/12/08 12:41:58 $
 */
public class DeleteCommandsTest extends TestCase {

    private TextModificator _tm;
    private final String _documentContent =
        "1. first second, third, ..., last\r\n"
        + "2. ffirst, ssecond, tthird, ..., llast\r\n"
        + "3. ffirst, ssecond, tthird, ..., llast\r\n"
        + "4. ffirst, ssecond, tthird, ..., llast";
    
	/**
	 * Constructor.
	 * 
	 * @param name testName
	 */
	public DeleteCommandsTest(String name) {
		super(name);
	}

    protected void setUp() throws Exception
    {
        SharedTestResources.setConfiguredTextModificator(_documentContent);
        _tm = TextModificator.getInstance();
    }

	public void testDeleteWordForward() {
		Command goToFirstLine = new GoToFirstLine();
		goToFirstLine.execute();
		
		Command dw = new DeleteWordForward(1);
		dw.execute();
		assertEquals(". first second, third, ..., last", _tm.getLineText());
		dw.undo();
		Command dw3 = new DeleteWordForward(3);
		dw3.execute();
		assertEquals("second, third, ..., last", _tm.getLineText());
		dw3.undo();
		assertEquals("1. first second, third, ..., last", _tm.getLineText());
	}
}
