/*******************************************************************************
 * Copyright (c) 2003, Michael Bartl
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Created on 09.01.2004
 *******************************************************************************/

package viPlugin.test;

import junit.framework.TestCase;
import viPlugin.CommandParser;

/**
 * @author Michael Bartll
 */
public class CommandParserTest extends TestCase {

	final public void testCommandParser() {
		CommandParser parser = new CommandParser();
		parser.parse("cc");
		assertEquals(parser._counter, 1);
		assertEquals(parser._operation, "cc");
		assertEquals(parser._modifier, "c");
		parser.parse("3dd");
		assertEquals(parser._counter, 3);
		assertEquals(parser._operation, "dd");
		assertEquals(parser._modifier, "d");
		parser.parse("3d3w");
		assertEquals(parser._counter, 9);
		assertEquals(parser._operation, "dw");
		assertEquals(parser._modifier, "w");
		parser.parse("d2tx");
		assertEquals(2, parser._counter);
		assertEquals("dtx", parser._operation);
		assertEquals("tx", parser._modifier);
		parser.parse(">>");
		assertEquals(1, parser._counter);
		assertEquals(">>", parser._operation);
		assertEquals(">", parser._modifier);
		parser.parse("3<<");
		assertEquals(3, parser._counter);
		assertEquals("<<", parser._operation);
		assertEquals("<", parser._modifier);
		parser.parse("11d10d");
		assertEquals(110, parser._counter);
		assertEquals("dd", parser._operation);
		assertEquals("d", parser._modifier);
		parser.parse("r3");
		assertEquals(1, parser._counter);
		assertEquals("r3", parser._operation);
		assertEquals("3", parser._modifier);
		parser.parse("d0");
		assertEquals(1, parser._counter);
		assertEquals("d", parser._operation);
		assertEquals("0", parser._modifier);
	}
}
