/*
 * Created on Jul 17, 2003
 *
 */
package viPlugin.preferences.commands;

import org.eclipse.core.runtime.Preferences;

import viPlugin.ViPluginPlugin;

/**
 * 
 * @author Kristian Argillander
 *
 */
abstract class AbstractSetPrefCommand implements SetPrefCommand 
{
	private String _prefName;
	
	public AbstractSetPrefCommand(String prefName)
	{
		_prefName = prefName;
	}
	
	public void execute(String value) 
	{
		Preferences preferences = getPreferences();
		setValue(preferences,_prefName,value);
	}

	protected abstract void setValue(Preferences prefs, String name, String value);

	protected Preferences getPreferences() {
		Preferences preferences = ViPluginPlugin.getDefault().getPluginPreferences();
		return preferences;
	}

}
