/*
 * Created on Jul 17, 2003
 *
 */
package viPlugin.preferences;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.Preferences;

import viPlugin.ViPluginPlugin;
import viPlugin.preferences.commands.SetBoolean;
import viPlugin.preferences.commands.SetPrefCommand;
import viPlugin.preferences.commands.UnSetBoolean;

/**
 * @author Kristian Argillander
 *  
 */
public class ViPreferenceService {

    private static ViPreferenceService _instance;
    private Preferences _preferences;
    private Map _prefCommands;

    private void initCommandMappings() {
        _prefCommands = new HashMap();

        Map pf = _prefCommands;

        SetPrefCommand c = null;

        c = new SetBoolean(ViPrefNames.IGNORECASE);
        pf.put("ic", c);
        pf.put("ignorecase", c);

        c = new UnSetBoolean(ViPrefNames.IGNORECASE);
        pf.put("noic", c);
        pf.put("noignorecase", c);

        c = new SetBoolean(ViPrefNames.VIMCURSOR);
        pf.put("vc", c);
        pf.put("vimcursor", c);

        c = new UnSetBoolean(ViPrefNames.VIMCURSOR);
        pf.put("novc", c);
        pf.put("novimcursor", c);
    }

    private ViPreferenceService() {
        _preferences = ViPluginPlugin.getDefault().getPluginPreferences();
        initCommandMappings();
    }

    public static ViPreferenceService getInstance() {
        if (_instance == null) {
            _instance = new ViPreferenceService();
        }
        return _instance;
    }

    public void eval(String name, String value) {
        SetPrefCommand command = (SetPrefCommand) _prefCommands.get(name);

        command.execute(value);
    }

    public boolean getBoolean(String name) {
        return _preferences.getBoolean(name);
    }

    public String getString(String name) {
        return _preferences.getString(name);
    }

    public int getInt(String name) {
        return _preferences.getInt(name);
    }

}
