package viPlugin.preferences;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import viPlugin.ViPluginPlugin;

/**
 * viPlugin preference page settings.
 * 
 * @author Kristian Argillander
 */

public class ViPluginPreferencePage
	extends FieldEditorPreferencePage
	implements IWorkbenchPreferencePage {

	public ViPluginPreferencePage() {
		super(GRID);
		setPreferenceStore(ViPluginPlugin.getDefault().getPreferenceStore());
	}

	
	public void createFieldEditors() 
	{
		addField(new BooleanFieldEditor(ViPrefNames.VIMCURSOR, "Vim &Cursor Style", getFieldEditorParent()));
		addField(new BooleanFieldEditor(ViPrefNames.IGNORECASE, "&Ignorecase", getFieldEditorParent()));

	}
	
	public void init(IWorkbench workbench) {
	}
}