/*******************************************************************************
 * Copyright (c) 2003, Michael Bartl
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Created on 26.05.2003
 *******************************************************************************/

package viPlugin.editors;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.TextEditor;

import viPlugin.CommandBuffer;
import viPlugin.ILayerInterface;

/**
 * @author Michael Bartl
 */
public class ViEditor extends TextEditor implements ILayerInterface {

	private IStatusLineManager slm;
	private static CommandBuffer commandBuffer;
	private NewVerifyKeyListener newVerifyKeyListener;
	private StyledText textWidget;
	private short mode;
	private final short COMMANDMODE = 0;
	private final short INSERTMODE = 1;
	private final short VISUALMODE = 2;

	private class NewVerifyKeyListener implements VerifyKeyListener {
		public void verifyKey(VerifyEvent e) {
//			System.out.println("VerifyEvent = " + (int)e.character + ", " + e.keyCode + ", " + e.stateMask);
			if (e.character == SWT.ESC) {
				// close IME window for platform.
				e.display.getActiveShell().setImeInputMode(SWT.NONE);
				if (mode == INSERTMODE) {
					mode = COMMANDMODE;
				}
				commandBuffer.clear();
				setStatusLine();
				e.doit = false;
			} else if (mode == COMMANDMODE) {
				// not keyCode but character for Ctrl+M and IME.
				switch (e.character) {
				case 0:	// Arrow, Ctrl, Shift, Alt, Arrow key.
					e.doit = true;
					break;
				case SWT.BS:
					commandBuffer.backspace();
					commandBuffer.eval();
					setStatusLine();
					e.doit = false;
					break;
				case 13:	// ENTER
					// close IME window for platform.
					e.display.getActiveShell().setImeInputMode(SWT.NONE);
					commandBuffer.append(e.character);	// \n following / or :
					commandBuffer.eval();
					setStatusLine();
					e.doit = false;
					break;
				default:
					commandBuffer.append(e.character);
					commandBuffer.eval();
					setStatusLine();
					e.doit = false;
					break;
				}
			}
		}
	}

	public ViEditor() {
		super();
		newVerifyKeyListener = new NewVerifyKeyListener();
	}

	public void createPartControl(Composite parent) {
		super.createPartControl(parent);
		slm = getEditorSite().getActionBars().getStatusLineManager();
		textWidget = getSourceViewer().getTextWidget();
		textWidget.addVerifyKeyListener(newVerifyKeyListener);
		mode = COMMANDMODE;
//		commandBuffer = new CommandBuffer(this);
		try {
//			TODO: TextModificator.getInstance().setTextEditor(this);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private void setStatusLine() {
		String message = new String();
		if (mode == COMMANDMODE) {
			message =
				"CommandMode: CommandBuffer = " + commandBuffer.getCommand();
		} else if (mode == INSERTMODE) {
			message = "InsertMode";
		}
		else if (mode == VISUALMODE) {
			message = "VisualMode";
		}
		else {
			message = "MODE NOT SUPPORTED - SOMETHING IS VERY WRONG!";
		}
		slm.setMessage(message);
	}

	/**
	 * @see viplugin.ILayerInterface#switchToCommandMode()
	 */
	public void switchToCommandMode() {
		mode = COMMANDMODE;
		commandBuffer.clear();
		setStatusLine();
	}

	/**
	 * @see viplugin.ILayerInterface#switchToInsertMode()
	 */
	public void switchToInsertMode() {
		mode = INSERTMODE;
		commandBuffer.clear();
		setStatusLine();
	}

	/* 
	 * unLoad is not needed for the editor
	 */
	public void unLoad() {
		// not used
	}

	/* (non-Javadoc)
	 * @see viPlugin.ILayerInterface#switchToVisualMode()
	 */
	public void switchToVisualMode() {
		// TODO Auto-generated method stub
	}
}
