package viPlugin.commands.select;

import viPlugin.commands.Command;

/**
 * Factory for selection commands.
 * 
 * @author <a href="mailto:emdot@seznam.cz">Martin Krauskopf</a>
 * @version $Revision: 1.1 $ $Date: 2003/12/04 09:11:51 $
 */
public class SelectionCommandFactory {

	/**
	 * Returns command corresponding to the given parameters.
	 * 
	 * @param operation operation
	 * @param modifier modifier
	 * @param counter counter
	 * @return command
	 */
	public static Command createCommand(
		String operation,
		String modifier,
		int counter) {

		String o = operation;
		String m = modifier;
		int c = counter;
		Command command;
		if (m.equals("w")) {
			command = new SelectWord(c);
		} else if (m.equals("e")) {
			// TODO: create own command for 'e'
			command = new SelectWord(c);
		} else {
			command = null;
		}
		return command;
	}
}
