/*
 * $Id: SelectWord.java,v 1.3 2004/04/13 22:17:33 midramas Exp $
 */

package viPlugin.commands.select;

import viPlugin.TextModificator;

/**
 * Select word command.
 * 
 * @author <a href="mailto:emdot@seznam.cz">Martin Krauskopf</a>
 * @version $Revision: 1.3 $ $Date: 2004/04/13 22:17:33 $
 */
public class SelectWord extends SelectionCommand {

	private int _counter;

	public SelectWord(int counter) {
		_counter = counter;
	}

	/*
	 *  (non-Javadoc)
	 * @see viPlugin.commands.Command#execute()
	 */
	public void execute() {
		TextModificator tm = TextModificator.getInstance();
		int start = tm.getCaretPosition();
		int end = start;
		String text = tm.getDocument().get();
		for (int i = 0; i < _counter; i++) {
			end = tm.getNextWord(text, end);
		}
		int length = end - start;
		tm.setInternalSelection(start, length);
	}
}
