/*******************************************************************************
 * Copyright (c) 2003, Michael Bartl
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Created on Jun 21, 2003
 *******************************************************************************/

package viPlugin.commands.select;

import org.eclipse.jface.text.IRegion;

import viPlugin.TextModificator;

/**
 * Select text to the first non-blank character on the line.
 * 
 * @author <a href="mailto:emdot@seznam.cz">Martin Krauskopf</a>
 * @version $Revision: 1.3 $ $Date: 2004/04/13 22:17:33 $
 */
public class SelectToLineBeginNonBlank extends SelectionCommand {

	public void execute() {
		TextModificator tm = TextModificator.getInstance();
		int cursorPos = tm.getCaretPosition();
		IRegion line = tm.getLine();
		int beginOfLine =
			tm.getNextNonBlankCharacter(
				tm.getDocument().get(),
				line.getOffset());
		tm.setInternalSelection(beginOfLine, cursorPos - beginOfLine);
	}
}
