/*******************************************************************************
 * Copyright (c) 2003, Michael Bartl
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Created on Jun 21, 2003
 *******************************************************************************/

package viPlugin.commands.select;

import org.eclipse.jface.text.IRegion;

import viPlugin.TextModificator;

/**
 * @author Michael Bartl
 */
public class SelectToLineBegin extends SelectionCommand {

	public void execute() {
		TextModificator tm = TextModificator.getInstance();
		int cursorPos = tm.getCaretPosition();
		IRegion line = tm.getLine();
		int offset = line.getOffset();
		tm.setInternalSelection(offset, cursorPos - offset);
	}
}
