/*******************************************************************************
 * Copyright (c) 2003, Michael Bartl
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Created on Jun 24, 2003
 *******************************************************************************/

package viPlugin.commands.select;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;

import viPlugin.TextModificator;

/**
 * @author Michael Bartl
 */
public class SelectLines extends SelectionCommand {

	private int lines;
	private boolean checkLastDelimiter;
	private int direction;
	public static final int UP = 0;
	public static final int DOWN = 1;

	/**
	 * Selects a specific number of lines
	 * 
	 * @param lines: number of lines to select
	 * @param direction: upwards or downwards
	 * @param checkLastDelimiter check if last delimiter is in selection. if
	 *            yes set deleteLastDelimiter to true
	 */
	public SelectLines(int lines, int direction, boolean checkLastDelimiter) {
		this.lines = lines;
		this.checkLastDelimiter = checkLastDelimiter;
		this.direction = direction;
	}

	public void execute() {
		TextModificator tm = TextModificator.getInstance();
		try {
			int startLinePos;
			int endLinePos;
			IRegion startLine;
			IRegion endLine;

			if (direction == DOWN) {
				startLine = tm.getLine();
				startLinePos = tm.getLinePos();
				endLinePos = startLinePos + lines - 1;
				// selection includes last line
				if (tm.getDocument().getNumberOfLines() <= endLinePos + 1) {
					endLinePos = tm.getDocument().getNumberOfLines() - 1;
					if (checkLastDelimiter && startLinePos > 0) {
						tm.setDeleteLastDelimiter(true);
					}
				}
				endLine = tm.getDocument().getLineInformation(endLinePos);
			}
			// select upwards
			else {
				endLinePos =
					tm.getDocument().getLineOfOffset(tm.getCaretPosition());
				endLine = tm.getDocument().getLineInformation(endLinePos);
				startLinePos = endLinePos - lines;
				if (startLinePos < 0) {
					startLinePos = 0;
				}
				startLine = tm.getDocument().getLineInformation(startLinePos);
			}

			String delim = tm.getLineDelimiter(endLinePos);

			// finally calculate the borders
			int start = startLine.getOffset();

			int length =
				endLine.getOffset()
					+ endLine.getLength()
					- start
					+ delim.length();

			tm.setInternalSelection(start, length);
			tm.deactivateVisualMode();
		} catch (BadLocationException e) {
			e.printStackTrace();
		}
	}
}
