/*******************************************************************************
 * Copyright (c) 2003, Michael Bartl
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Created on Jun 25, 2003
 *******************************************************************************/

package viPlugin.commands.search;

import org.eclipse.jface.text.BadLocationException;

import viPlugin.TextModificator;

/**
 * Search related functions.
 * @author Michael Bartl
 */
public class SimpleSearch extends Search {
	/**
	 * start a new search
	 */
	public boolean search(String str, int mode) throws Exception {
		try {
			if (str == null) {
				throw new Exception("Got an emptry string for searching!");
			}
			_tm = TextModificator.getInstance();
			_doc = _tm.getDocument();
			_selection = _tm.getSelection();

			_lastSearch = str;
			String text = _doc.get();
			int cursorPos = _selection.getOffset();

			if (mode == NEXT) {
				cursorPos++;
			} else if (mode == PREVIOUS) {
				cursorPos--;
			}

			int cursor;
			if (mode == NEW || mode == NEXT) {
				cursor = text.indexOf(str, cursorPos);
				if (cursor == -1) {
					cursor = text.indexOf(str);
				}
			} else {
				cursor = text.lastIndexOf(str, cursorPos);
				if (cursor == -1) {
					cursor = text.lastIndexOf(str);
				}
			}
			if (cursor != -1) {
				_tm.setCaretPosition(cursor);
				_tm.setVisualSelection(cursor, str.length());
			}
			return str.length() > 0;
		} catch (BadLocationException e) {
			e.printStackTrace();
		}
		return false;
	}

}
