package viPlugin.commands.search;

import org.eclipse.swt.SWT;

import viPlugin.TextModificator;
import viPlugin.ViVerifyKeyListener;
import viPlugin.commands.Command;


/**
 * DOCDO
 *
 * @author Kristian Argillander
 * @version $Revision: 1.1 $ $Date: 2004/04/06 21:29:57 $
 */
public class SearchDelegate {

	private ISearch _search;
	private boolean _searchFinished;

	private Command _postCommand;

	public SearchDelegate(ISearch search) {
		_search = search;
		_searchFinished = false;
	}

	public SearchDelegate(ISearch search, Command postCommand) {
		this(search);
		_postCommand = postCommand;
	}

	public boolean search(String o) throws Exception {
		if (o.length() > 1) {
			if (o.endsWith(String.valueOf(SWT.ESC))) {
				_searchFinished = true;
				TextModificator.getInstance().resetSelection();
				return false;
			} else if (
				!o.endsWith(String.valueOf(ViVerifyKeyListener.ENTER))) {
				return _search.search(o.substring(1));
			} else {
				executePostCommand();
				_searchFinished = true;
			}
		}
		return false;
	}
	
	private void executePostCommand() {
		if (_postCommand != null) {
			_postCommand.execute();
		}
	}

	public boolean searchFinished() {
		return _searchFinished;
	}
}
