/*******************************************************************************
 * Copyright (c) 2003, Michael Bartl
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Created on Jun 25, 2003
 *******************************************************************************/

package viPlugin.commands.search;

/**
 * @author Michael Bartl
 */
public interface ISearch {

    /**
     * search again with the lastSearch string
     */
    public boolean searchNext() throws Exception;

    /**
     * search again with the lastSearch string, but backwards
     */
    public boolean searchPrevious() throws Exception;

    /**
     * Start a new search for str in the current Document beginning at the
     * cursor position. DOCDO when is the exception thrown
     * @return true if str was found 
     */
    public boolean search(String str) throws Exception;
	/**
	 * the implementation of the search functionality
	 */
    public boolean search(String str, int mode) throws Exception;

    public void searchCurrentWord() throws Exception;

    public void searchCurrentWordBackwards() throws Exception;
}