package viPlugin.commands.motion;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

import viPlugin.TextModificator;

/**
 * Move word forward command.
 *
 * @author <a href="mailto:emdot@seznam.cz">Martin Krauskopf</a>
 * @version $Revision: 1.5 $ $Date: 2004/02/25 12:02:09 $
 */
public class MoveWordForward extends MotionCommand {

	public MoveWordForward(int counter) {
		super(counter);
	}

	public void execute() {
		TextModificator tm = TextModificator.getInstance();
		IDocument _document = tm.getDocument();
		String text = _document.get();
		int newCursor = tm.getCaretPosition();
		for (int i = 0; i < _counter; i++) {
			newCursor = tm.getNextWord(text, newCursor);
		}
		try {
			tm.setCaretPosition(newCursor);
		} catch (BadLocationException e) {
			e.printStackTrace();
		}
	}
}
