package viPlugin.commands.motion;

import viPlugin.ViVerifyKeyListener;
import viPlugin.commands.Command;

/**
 * Factory for motion commands.
 * 
 * @author <a href="mailto:emdot@seznam.cz">Martin Krauskopf</a>
 * @version $Revision: 1.3 $ $Date: 2003/12/01 08:32:24 $
 */
public class MotionCommandFactory {

	/**
	 * Returns command corresponding to the given parameters.
	 * 
	 * @param operation operation
	 * @param counter counter
	 * @param useCounter useCounter
	 * @return command
	 */
	public static Command createCommand(
		String operation,
		int counter,
		boolean useCounter) {

		String o = operation;
		int c = counter;
		boolean uc = useCounter;
		Command command = null;
		if (o.equals("h") || o.equals("<CL>")) {
			command = new MoveLeft(c);
		} else if (o.equals("l") || o.equals("<CR>") || o.equals(" ")) {
			command = new MoveRight(c);
		} else if (o.equals("j") || o.equals("<CD>")) {
			command = new MoveDown(c);
		} else if (o.equals(ViVerifyKeyListener.ENTER_STRING)) {
			command = new EnterCommand(c);
		} else if (o.equals("k") || o.equals("<CU>")) {
			command = new MoveUp(c);
		} else if (o.equals("w")) {
			command = new MoveWordForward(c);
		} else if (o.equals("b")) {
			command = new MoveWordBackward(c);
		} else if (o.equals("gg")) {
			command = new GotoLine(c, uc, GotoLine.FIRST);
		} else if (o.equals("G")) {
			command = new GotoLine(c, uc, GotoLine.LAST);
		} else if (o.startsWith("t") && o.length() > 1) {
			command = new MoveBeforeChar(c, o.charAt(1));
		} else if (o.equals("0")) {
			command = new MoveToLineBegin();
		}
		return command;
	}
}
