/*
 * $Id: MotionCommand.java,v 1.3 2003/12/04 09:12:37 emdot Exp $
 */

package viPlugin.commands.motion;

import viPlugin.commands.Command;

/**
 * Should be extended by motion commands which doesn't use undo operation.
 * 
 * @author <a href="mailto:emdot@seznam.cz">Martin Krauskopf</a>
 * @version $Revision: 1.3 $ $Date: 2003/12/04 09:12:37 $
 */
abstract class MotionCommand extends Command {

	protected int _counter;

	/**
	 * Creates instance and sets the counter.
	 * 
	 * @param counter number of repetitions
	 */
	public MotionCommand(int counter) {
		_counter = counter;
	}

	/* (non-Javadoc)
	 * @see viPlugin.commands.Command#saveUndo()
	 */
	public boolean saveUndo() {
		return false;
	}

	/* (non-Javadoc)
	 * @see viPlugin.commands.Command#undo()
	 */
	public void undo() {
		// not used by motion commands
	}
}
