package viPlugin.commands.motion;

import viPlugin.TextModificator;
import viPlugin.commands.Command;

/**
 * Goto line command.
 *
 * @author <a href="mailto:emdot@seznam.cz">Martin Krauskopf</a>
 * @version $Revision: 1.3 $ $Date: 2003/11/26 18:06:56 $
 */
public class GotoLine extends MotionCommand {

	private int _defaultLine;
	private boolean _useCounter;

	public static final int FIRST = 0;
	public static final int LAST = 1;

	public GotoLine(int counter, boolean useCounter, int defaultLine) {
		super(counter);
		_defaultLine = defaultLine;
		_useCounter = useCounter;
	}

	/* (non-Javadoc)
	 * @see viPlugin.commands.Command#execute()
	 */
	public void execute() {
		TextModificator tm = TextModificator.getInstance();
		if (_useCounter && _counter != 0) {
			tm.cursorToLine(_counter - 1, true);
		} else {
			Command command;
			if (_defaultLine == FIRST) {
				command = new GoToFirstLine();
			} else {
				command = new GoToLastLine();
			}
			command.execute();
		}
	}
}
