/*
 * $Id: DeleteWordForward.java,v 1.1 2003/12/04 09:11:23 emdot Exp $
 */
package viPlugin.commands.delete;

import viPlugin.commands.Command;
import viPlugin.commands.DeleteSelection;
import viPlugin.commands.YankSelection;
import viPlugin.commands.select.SelectWord;

/**
 * Delete word(s) command.
 * 
 * @author <a href="mailto:emdot@seznam.cz">Martin Krauskopf</a>
 * @version $Revision: 1.1 $ $Date: 2003/12/04 09:11:23 $
 */
public class DeleteWordForward extends Command {

	private int _counter;
	private DeleteSelection _delete;

	public DeleteWordForward(int counter) {
		_counter = counter;
	}

	/*
	 *  (non-Javadoc)
	 * @see viPlugin.commands.Command#execute()
	 */
	public void execute() {
		Command select = new SelectWord(_counter);
		select.execute();
		Command yank = new YankSelection();
		yank.execute();
		_delete = new DeleteSelection(false);
		_delete.execute();
	}

	/*
	 *  (non-Javadoc)
	 * @see viPlugin.commands.Command#saveUndo()
	 */
	public boolean saveUndo() {
		return true;
	}

	/*
	 *  (non-Javadoc)
	 * @see viPlugin.commands.Command#undo()
	 */
	public void undo() {
		_delete.undo();
	}

}
