/*******************************************************************************
 * Copyright (c) 2003, Michael Bartl
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Created on Jun 21, 2003
 *******************************************************************************/
 
package viPlugin.commands;

import org.eclipse.jface.text.ITextSelection;

import viPlugin.TextModificator;

/**
 * @author Michael Bartl
 */
public class YankSelection extends Command {

	public YankSelection() {
		super();
	}
	
	/*
	 *  (non-Javadoc)
	 * @see viPlugin.commands.Command#execute()
	 */
	public void execute() {
		TextModificator tm = TextModificator.getInstance();
		ITextSelection selection = tm.getSelection();
		tm.getYankBuffer().getBuffer("<default>").fill(selection.getText());
	}

	/*
	 *  (non-Javadoc)
	 * @see viPlugin.commands.Command#undo()
	 */
	public void undo() {
		// not used
	}

	/**
	 * @see viPlugin.commands.Command#saveUndo()
	 */
	public boolean saveUndo() {
		return false;
	}
}
