/*******************************************************************************
 * Copyright (c) 2003, Michael Bartl
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Created on Jun 24, 2003
 *******************************************************************************/

package viPlugin.commands;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;

import viPlugin.TextModificator;

/**
 * @author Michael Bartl
 */
public class ShiftSelection extends Command {
//	private int _pos;
	private TextModificator _tm;
	private IDocument _doc;
	private ITextSelection _selection;
	private int _startLinePos;
	private int _endLinePos;
	private int _counter;
	private int _direction;
	public static final int LEFT = 0;
	public static final int RIGHT = 1;

	public ShiftSelection(int counter, int direction) {
		_tm = TextModificator.getInstance();
		_doc = _tm.getDocument();
		_selection = _tm.getSelection();
		_startLinePos = _selection.getStartLine();
		_endLinePos = _selection.getEndLine();
		
		// For some reason, endLine == startLine -1
		// when no selection and cursor at beginning
		// of line. 
		_endLinePos = Math.max(_startLinePos, _endLinePos);
		
		// If there isn't selection, vim consider 
		// n lines are shifted one time.
		// With selection, selected lines are shifted n times.
		if(_selection.getLength()==0) {
			_counter = 1;
			_endLinePos += counter - 1;

			// don't exceed document boundaries
			_endLinePos = 
				Math.min(_doc.getNumberOfLines()-1, _endLinePos);
		} else	{
			_counter = counter;
		}
		_direction = direction;
	}

	/* (non-Javadoc)
	 * @see viPlugin.commands.ICommand#execute()
	 */
	public void execute() {
		try {
			StringBuffer shiftedBuffer = new StringBuffer();
			for (int i = _startLinePos; i <= _endLinePos; i++) {
				shiftLine(i, _counter, _direction, shiftedBuffer);
			}
			IRegion startLine = _doc.getLineInformation(_startLinePos);
			IRegion endLine = _doc.getLineInformation(_endLinePos);
			
			int startPos = startLine.getOffset();
			int selectionLength = 
				endLine.getOffset() + endLine.getLength() 
				- startPos;
				
			String endLineDelimiter = _doc.getLineDelimiter(_endLinePos);
			if(endLineDelimiter!=null)
				selectionLength += endLineDelimiter.length();

			_doc.replace( startPos, selectionLength, ""+shiftedBuffer);

			// set cursor to first visible character of starting line
			int newPos = startPos;
			newPos += _tm.getFirstVisibleCharacter(_doc.get(newPos, startLine.getLength()));
			_tm.setCaretPosition(newPos);
		} catch (BadLocationException e) {
			e.printStackTrace();
		}
	}

	private void shiftLine(int linePos, int c, int direction, StringBuffer shiftedBuffer) {
		try {
			IRegion line = _doc.getLineInformation(linePos);
			StringBuffer text;
			text =
				new StringBuffer(
					_doc.get(line.getOffset(), line.getLength()));

				
			for (int i = 0; i < c; i++) {
				if (direction == LEFT) {
					if (text.length() > 0 && text.charAt(0) == '\t') {
						text.deleteCharAt(0);
					} else {
						break;
					}
				} else {
					text.insert(0, '\t');
				}
			}
			shiftedBuffer.append(""+text);

			String lineDelimiter = _doc.getLineDelimiter(linePos);
			if(lineDelimiter!=null)
				shiftedBuffer.append(lineDelimiter);
		} catch (BadLocationException e) {
			e.printStackTrace();
		}
	}

	/* (non-Javadoc)
	 * @see viPlugin.commands.ICommand#saveUndo()
	 */
	public boolean saveUndo() {
		return true;
	}

	/* (non-Javadoc)
	 * @see viPlugin.commands.ICommand#undo()
	 */
	public void undo() {
		invertDirection();
		execute();
		invertDirection();
	}
	private int invertDirection() {
		return _direction = _direction == LEFT ? RIGHT : LEFT;
	}

}
