/*******************************************************************************
 * Copyright (c) 2003, Michael Bartl
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Created on Jun 25, 2003
 *******************************************************************************/

package viPlugin.commands;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;

import viPlugin.TextModificator;
import viPlugin.commands.search.*;

public class ReplaceString extends Command {

    private String _match;
    private String _replace;
    private String _undoText;
    private int _pos;
    private int _counter;
    private int _startingLine = -1;
    private int _startingOffset = -1;
    private boolean _global;
    private TextModificator _tm;
    private IDocument _doc;
    private ITextSelection _selection;
    private SearchDelegate _searchDelegate;
    private ISearch _search;

    public ReplaceString(String command) {
        if (command == null) throw new IllegalArgumentException();
        if (!command.startsWith("%s/")) throw new IllegalArgumentException();
        command = command.substring(3);
        if (command.endsWith("/g")) {
            command = command.substring(0, command.length() - 2);
            _global = true;
        } else if (command.endsWith("/")) {
            command = command.substring(0, command.length() - 1);
        }
        boolean foundSlash = false;
        boolean nextIsEscaped = false;
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < command.length(); i++) {
            switch (command.charAt(i)) {
            case '\\':
                nextIsEscaped = !nextIsEscaped;
                if (!foundSlash) sb.append(command.charAt(i));
                break;
            case '/':
                if (!nextIsEscaped) {
                    foundSlash = true;
                    _match = sb.toString();
                    sb = new StringBuffer("");
                } else
                    sb.append(command.charAt(i));
                nextIsEscaped = false;
                break;
            default:
                nextIsEscaped = false;
                sb.append(command.charAt(i));
            }
        }
        _match = _match.startsWith("/") ? _match : "/" + _match;
        _replace = sb.toString();
        _tm = TextModificator.getInstance();
        _doc = _tm.getDocument();
        if (RegExSearch.isSupported(true)) {
            _search = new RegExSearch();
        } else {
            _search = new SimpleSearch();
        }
    }

    public void execute() {
        try {
            boolean searching = true, isStart = true, firstSearch = true;
            _counter = 0;
            _searchDelegate = new SearchDelegate(_search);
            if (_searchDelegate.search(_match)) {
                do {
                    firstSearch = (_startingLine == -1 && _startingOffset == -1);
                    if (firstSearch) {
                        _startingLine = _tm.getLinePos();
                        _startingOffset = _tm.getCaretPosition();
                    }
                    _counter++;
                    _selection = _tm.getSelection();
                    _pos = _selection.getOffset();
                    _undoText = _selection.getText();
                    _doc.replace(_pos, _match.length() - 1, _replace);
                    searching = _global
                            && (_search.searchNext() && _search.searchNext());
                    isStart = _global
                            && ((_startingLine != _tm.getLinePos() || (_startingOffset != _tm
                                    .getCaretPosition())) || (firstSearch));
                } while (_global && searching && isStart);
            }
        } catch (BadLocationException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getNumberReplaced() {
        return _counter;
    }

    public void undo() {
        try {
            _doc.replace(_pos, _undoText.length(), _undoText);
        } catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    /**
     * @see viPlugin.commands.Command#saveUndo()
     */
    public boolean saveUndo() {
        return true;
    }
}