/*******************************************************************************
 * Copyright (c) 2003, Michael Bartl
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Created on Jun 27, 2003
*******************************************************************************/

package viPlugin.commands;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

import viPlugin.TextModificator;

/**
 * @author Michael Bartl
 */
public class PasteBelow extends Command {
	private String insertText;
	private int pos;
	private int cursorPos;
	private TextModificator tm;
	private IDocument doc;
//	private ITextSelection selection;
	private boolean fullLines;
	private InsertStringBelow insertStringBelow;

	public PasteBelow() {
		tm = TextModificator.getInstance();
		doc = tm.getDocument();
//		selection = tm.getSelection();
		insertText = tm.getYankBuffer().getBuffer("<default>").getText();
		fullLines = tm.getYankBuffer().getBuffer("<default>").getFullLines();
		cursorPos = tm.getCaretPosition();
	}

	public void execute() {
		try {
			if (!fullLines) {
				// check if on the last character
				int addPos = 1;
				IRegion line = tm.getLine();
//				String delim = tm.getLineDelimiter(tm.getLinePos());
				int endOfLinePos = line.getOffset() + line.getLength();

				if (cursorPos == endOfLinePos) {
					addPos = 0;
				}
				pos = cursorPos + addPos;
				doc.replace(cursorPos + addPos, 0, insertText);
			} else {
				insertStringBelow = new InsertStringBelow(insertText);
				insertStringBelow.execute();
			}
		} catch (BadLocationException e) {
			e.printStackTrace();
		}
	}

	public boolean saveUndo() {
		return false;
	}

	public void undo() {
		try {
			if (!fullLines) {
				doc.replace(pos, insertText.length(), "");
			} else {
				insertStringBelow.undo();
			}
		} catch (BadLocationException e) {
			e.printStackTrace();
		}
	}
}
