/*******************************************************************************
 * Copyright (c) 2003, Michael Bartl
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Created on Jun 27, 2003
*******************************************************************************/

package viPlugin.commands;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

import viPlugin.TextModificator;

/**
 * @author Michael Bartll
 */
public class PasteAbove extends Command {
	private String insertText;
	private String undoText;
	private int pos;
	private TextModificator tm;
	private IDocument doc;
	private boolean fullLines;
	private InsertStringAbove insertStringAbove;

	public PasteAbove() {
		tm = TextModificator.getInstance();
		doc = tm.getDocument();
		insertText = tm.getYankBuffer().getBuffer("<default>").getText();
		fullLines = tm.getYankBuffer().getBuffer("<default>").getFullLines();
	}

	public void execute() {
		undoText = insertText;
		pos = tm.getCaretPosition();
		try {
			if (!fullLines) {
				doc.replace(pos, 0, undoText);
			} else {
				if (!undoText.endsWith(tm.getDelimiter())) {
					undoText += tm.getDelimiter();
				}
				insertStringAbove = new InsertStringAbove(undoText);
				insertStringAbove.execute();
			}
		} catch (BadLocationException e) {
			e.printStackTrace();
		}
	}

	public boolean saveUndo() {
		return true;
	}

	public void undo() {
		try {
			if (!fullLines) {
				doc.replace(pos, undoText.length(), "");
			} else {
				insertStringAbove.undo();
			}
		} catch (BadLocationException e) {
			e.printStackTrace();
		}
	}
}

