package viPlugin.commands;

import viPlugin.TextModificator;
import viPlugin.commands.search.*;

/**
 * DOCDO
 * 
 * @author Michael Bartl
 * @version $Revision: 1.7 $ $Date: 2004/04/07 12:16:10 $
 */
public class MatchBrace extends Command {

    private ISearch _search = null;
    private String _searchString = "[{}\\(\\)\\[\\]<>]";
    private String _nString = "";
    private String _fString = "";
    private boolean _forward = false;
    private TextModificator _tm = null;

    public MatchBrace() {
        if (RegExSearch.isSupported(true)) {
            _search = new RegExSearch();
            _tm = TextModificator.getInstance();
        }
    }

    public void execute() {
        if (_search == null) return;
        try {
            String selection = _tm.getSelection().getText();
            setSearchParameters(selection);
            if (_fString.length() == 0) {
                _search.search(_searchString);
            } else {
                if (_forward) {
                    getNextBrace();
                } else {
                    getPreviousBrace();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getNextBrace() throws Exception {
        int stack = 1;
        boolean found = false;
        // finds the starting brace
        _search.search(_searchString);
        while (!found && _search.searchNext()) {
            String selection = _tm.getSelection().getText();
            if (selection.equals(_nString)) {
                stack++;
            } else if (selection.equals(_fString.substring(1))) {
                stack--;
                if (stack == 0) found = true;
            }
        }
    }

    private void getPreviousBrace() throws Exception {
        int stack = 1;
        boolean found = false;
        // finds the ending brace
        _search.search(_searchString);
        while (!found && _search.searchPrevious()) {
            String selection = _tm.getSelection().getText();
            if (selection.equals(_nString))
                stack++;
            else if (selection.equals(_fString.substring(1))) {
                stack--;
                if (stack == 0) found = true;
            }
        }
    }
    
    private void setSearchParameters(final String select) {
        if (select == null || select.length() != 1) {
            _searchString = "[\\[\\]{}()<>]";
            _forward = true;
            return;
        }
        switch (select.charAt(0)) {
        case '{':
            _searchString = "[{}]";
            _forward = true;
            _fString = "\\}";
            _nString = "{";
            break;
        case '}':
            _searchString = "[{}]";
            _forward = false;
            _fString = "\\{";
            _nString = "}";
            break;
        case '(':
            _searchString = "[\\)\\(]";
            _forward = true;
            _fString = "\\)";
            _nString = "(";
            break;
        case ')':
            _searchString = "[\\)\\(]";
            _forward = false;
            _fString = "\\(";
            _nString = ")";
            break;
        case '[':
            _searchString = "[\\[\\]]";
            _forward = true;
            _fString = "\\]";
            _nString = "[";
            break;
        case ']':
            _searchString = "[\\[\\]]";
            _forward = false;
            _fString = "\\[";
            _nString = "]";
            break;
        case '<':
            _searchString = "[<>]";
            _forward = true;
            _fString = "\\>";
            _nString = "<";
            break;
        case '>':
            _searchString = "[<>]";
            _forward = false;
            _fString = "\\<";
            _nString = ">";
            break;
        default:
            _searchString = "[{}()\\[\\]<>]";
            _forward = true;
            break;
        }
    }
}