package viPlugin.commands;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

import viPlugin.TextModificator;

/**
 * Joins two lines and insert a space between them.
 * 
 * @author <a href="mailto:emdot@seznam.cz">Martin Krauskopf</a>
 * @version $Revision: 1.2 $ $Date: 2003/11/24 18:25:58 $
 */
public class LineJoin extends Command {

	private TextModificator tm;
	private IDocument doc;
	private int endOfFirstLine;
	private String origText;

	/*
	 *  (non-Javadoc)
	 * @see viPlugin.commands.Command#execute()
	 */
	public void execute() {
		tm = TextModificator.getInstance();
		doc = tm.getDocument();
		endOfFirstLine = tm.cursorToLineEnd();
		try {
			origText =
				tm.getText(
					endOfFirstLine,
					doc.getLineInformation(tm.getLinePos() + 1).getLength());

			int secondLineNonBlank =
				tm.getNextNonBlankCharacter(doc.get(), endOfFirstLine);
			doc.replace(
				endOfFirstLine,
				secondLineNonBlank - endOfFirstLine,
				" ");
		} catch (BadLocationException e) {
			e.printStackTrace();
		}
	}

	/*
	 *  (non-Javadoc)
	 * @see viPlugin.commands.Command#saveUndo()
	 */
	public boolean saveUndo() {
		return true;
	}

	/*
	 *  (non-Javadoc)
	 * @see viPlugin.commands.Command#undo()
	 */
	public void undo() {
		try {
			doc.replace(endOfFirstLine, 0, origText);
		} catch (BadLocationException e) {
			e.printStackTrace();
		}
	}
}
