/*******************************************************************************
 * Copyright (c) 2003, Michael Bartl
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Created on Jun 27, 2003
*******************************************************************************/

package viPlugin.commands;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

import viPlugin.TextModificator;

/**
 * @author Michael Bartl
 */
public class InsertStringBelow extends Command {
	private String insertText;
	private String undoText;
	private int pos;
	private TextModificator tm;
	private IDocument doc;

	public InsertStringBelow(String text) {
		insertText = text;
		tm = TextModificator.getInstance();
		doc = tm.getDocument();
	}

	public void execute() {
		undoText = insertText;
		try {
			IRegion line = tm.getLine();
			String delim = tm.getDelimiter();
			if (undoText.endsWith(delim)) {
				undoText = undoText.substring(0, undoText.length() - delim.length());
			}

			// if text is emptry try to get a smart cursor Position
			String whiteSpace = "";
			if (undoText.length() == 0) {
				int smartPos =
					tm.getFirstVisibleCharacter(
						doc.get(line.getOffset(), line.getLength()));
				if (smartPos != -1) {
					whiteSpace = doc.get(line.getOffset(), smartPos);
				}
			}

			// append line
			pos = line.getOffset() + line.getLength();
			undoText = delim + whiteSpace + undoText;
			doc.replace(pos, 0, undoText);
			IRegion newLine = doc.getLineInformation(tm.getLinePos() + 1);
			tm.setCaretPosition(newLine.getOffset() + newLine.getLength());
		} catch (BadLocationException e) {
			e.printStackTrace();
		}
	}

	public boolean saveUndo() {
		return false;
	}

	public void undo() {
		try {
			doc.replace(pos, undoText.length(), "");
		} catch (BadLocationException e) {
			e.printStackTrace();
		}
	}
}
