/*******************************************************************************
 * Copyright (c) 2003, Michael Bartl
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Created on Jun 23, 2003
 *******************************************************************************/
 
package viPlugin.commands;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

import viPlugin.TextModificator;

/**
 * @author Michael Bartl
 */
public class InsertStringAbove extends Command {
	private String insertText;
	private String undoText;
	private int pos;
	private TextModificator tm;
	private IDocument doc;

	public InsertStringAbove(String text) {
		insertText = text;
		tm = TextModificator.getInstance();
		doc = tm.getDocument();
	}

	public void execute() {
		try {
			IRegion line = tm.getLine();
			String delim = tm.getDelimiter();
			if (insertText.endsWith(delim)) {
				delim = "";
			}

			// if text is emptry try to get a smart cursor Position
			String whiteSpace = "";
			if (insertText.length() == 0) {
				int smartPos =
					tm.getFirstVisibleCharacter(
						doc.get(line.getOffset(), line.getLength()));
				if (smartPos != -1) {
					whiteSpace = doc.get(line.getOffset(), smartPos);
				}
			}

			pos = line.getOffset();
			undoText = whiteSpace + delim + insertText;
			doc.replace(pos, 0, undoText);
			IRegion newLine =
				doc.getLineInformationOfOffset(pos);
			tm.setCaretPosition(newLine.getOffset() + newLine.getLength());
		} catch (BadLocationException e) {
			e.printStackTrace();
		}
	}

	public void undo() {
		try {
			doc.replace(pos, undoText.length(), "");
		} catch (BadLocationException e) {
			e.printStackTrace();
		}
	}

	/**
	 * @see viPlugin.commands.Command#saveUndo()
	 */
	public boolean saveUndo() {
		return true;
	}

}
