/*******************************************************************************
 * Copyright (c) 2003, Michael Bartl
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Created on Jun 21, 2003
 *******************************************************************************/

package viPlugin.commands;

import org.eclipse.jface.text.ITextSelection;

import viPlugin.TextModificator;

/**
 * @author Michael Bartl
 */
public class ExtendSelectionToOffset extends Command {
	private int _offset;
	
	public ExtendSelectionToOffset(int offset)
	{
		_offset = offset;
	}

	public void execute() {
		TextModificator tm = TextModificator.getInstance();
		ITextSelection selection = tm.getSelection();

		int startOffset = selection.getOffset();
		int endOffset = selection.getOffset() + selection.getLength();

		if(endOffset < _offset)
			endOffset = _offset;
		else if(startOffset > _offset)
			startOffset = _offset;

		tm.setInternalSelection(startOffset, endOffset - startOffset);
	}

	public void undo() {
		// not implemeted
	}

	/**
	 * @see viPlugin.commands.Command#saveUndo()
	 */
	public boolean saveUndo() {
		return false;
	}
}
