/*******************************************************************************
 * Copyright (c) 2003, Michael Bartl
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Created on Jun 21, 2003
 *******************************************************************************/

package viPlugin.commands;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;

import viPlugin.TextModificator;

/**
 * @author Michael Bartl
 */
public class DeleteSelection extends Command {
	private boolean includeDelimiter;
	private String text;
	private int pos;
	private TextModificator tm;
	private IDocument doc;
	private ITextSelection selection;
	private boolean deleteLastDelimiter;
	private boolean fullLines;

	public DeleteSelection(boolean includeDelimiter) {
		this.includeDelimiter = includeDelimiter;
		tm = TextModificator.getInstance();
		doc = tm.getDocument();
		deleteLastDelimiter = tm.getDeleteLastDelimiter();
	}

	public void execute() {
		selection = tm.getSelection();
		fullLines = tm.getYankBuffer().getBuffer("<default>").getFullLines();
		text = tm.getYankBuffer().getBuffer("<default>").getText();
		
		try {
			int delim = 0;
			int includeLastDelim = 0;
			if (deleteLastDelimiter) {
				delim = tm.getDelimiter().length();
			}
			// for cc behaviour
			if (!includeDelimiter
				&& selection.getText().endsWith(tm.getDelimiter())) {
				includeLastDelim = tm.getDelimiter().length();
			}
			doc.replace(
				selection.getOffset() - delim,
				selection.getLength() + delim - includeLastDelim,
				"");

			// set cursor to linebegin
			if (fullLines) {
				int linePos =
					doc.getLineOfOffset(selection.getOffset() - delim);
				tm.cursorToLine(linePos, true);
			}
			tm.setDeleteLastDelimiter(false);
			// save undo information
			pos = selection.getOffset() - delim;
		} catch (BadLocationException e) {
			e.printStackTrace();
		}
	}

	public void undo() {
		try {
			doc.replace(pos, 0, text);
		} catch (BadLocationException e) {
			e.printStackTrace();
		}
	}

	/**
	 * @see viPlugin.commands.Command#saveUndo()
	 */
	public boolean saveUndo() {
		return true;
	}
}
