/*
 * Created on 13.04.2004
 */
package viPlugin.commands;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

import viPlugin.TextModificator;


/**
 * @author MBartl
 */

public class ChangeCaseSelection extends Command {
    
	public void execute() {
		TextModificator tm = TextModificator.getInstance();
		IDocument doc = tm.getDocument();
		int pos = tm.getSelection().getOffset();
		int length = tm.getSelection().getLength();

		// set the StringBuffer
		StringBuffer text;
		try {
			text = new StringBuffer(doc.get(pos, length));
		} catch (BadLocationException e) {
			e.printStackTrace();
			return;
		}

		// switch case
		for (int i = 0; i < text.length(); i++) {
			char ch = text.charAt(i);
			if (Character.isLetter(ch)) {
				if (Character.isLowerCase(ch)) {
					ch = Character.toUpperCase(ch);
				} else {
					ch = Character.toLowerCase(ch);
				}
				text.setCharAt(i, ch);
			}
		}

		// set document with new text
		try {
			doc.replace(pos, length, text.toString());
		} catch (BadLocationException e) {
			e.printStackTrace();
		}

	}

	public boolean saveUndo() {
		return true;
	}

	public void undo() {
	}
}
