/*******************************************************************************
 * Copyright (c) 2003, Michael Bartl
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Created on 16.07.2003
 *******************************************************************************/

package viPlugin.commands;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

import viPlugin.TextModificator;

/**
 * This class is the connection to the eclipse bookmark system. You can add or
 * goTo bookmarks with the respective functions.
 * 
 * @author Michael Bartl
 */
public class BookMark {

    public static void add(String name) {
        try {
            IMarker marker = getMarker(name, true);
            marker.setAttribute(IMarker.LINE_NUMBER, TextModificator
                    .getInstance().getLinePos() + 1);
            marker.setAttribute(IMarker.MESSAGE, name);
        } catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void goTo(String name) {
        IMarker marker = getMarker(name, false);
        if (marker != null) {
            int linepos = marker.getAttribute(IMarker.LINE_NUMBER, -1);
            TextModificator.getInstance().cursorToLine(linepos - 1, true);
        }
    }

    private static IMarker getMarker(String name, boolean create) {
        TextModificator tm = TextModificator.getInstance();
        IEditorInput editorInput = tm.getTextEditor().getEditorInput();
        if (editorInput instanceof IFileEditorInput == false) { return null; }

        IFileEditorInput fileEditorInput = (IFileEditorInput) editorInput;
        IFile file = fileEditorInput.getFile();

        try {
            // get all Bookmark Markers
            IMarker[] markers = file.findMarkers(IMarker.BOOKMARK, true,
                    IResource.DEPTH_INFINITE);

            // search if it exists already
            for (int i = 0; i < markers.length; i++) {
                if (markers[i].getAttribute(IMarker.MESSAGE, "--").compareTo(
                        name) == 0) { return markers[i]; }
            }

            // nothing found => if create == true create a new one
            if (create) { return file.createMarker(IMarker.BOOKMARK); }
        } catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }
}