/*******************************************************************************
 * Copyright (c) 2003, Michael Bartl
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Created on 26.05.2003
 *******************************************************************************/

package viPlugin.actions;

import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.MultiPagePropertiesEditor;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.ITextEditor;

import viPlugin.ViLayerFactory;
import viPlugin.ViPartListener;

/**
 * DOCDO
 * 
 * @author Michael Bartl
 */
public class ViToggleAction implements IWorkbenchWindowActionDelegate {

	private boolean toggled;
	private IWorkbenchWindow window;
	private static IPartListener partListener = new ViPartListener();
	
	public void run(IAction action) {
		if (!toggled) {
			window.getPartService().addPartListener(partListener);
			IEditorPart textEditor = window.getActivePage().getActiveEditor();
			if (textEditor instanceof ITextEditor ) {
				ViLayerFactory.getInstance().activateLayer((ITextEditor) textEditor);
			} else if (textEditor instanceof MultiPagePropertiesEditor) {
				ViLayerFactory.getInstance().activateLayer(((MultiPagePropertiesEditor) textEditor).getEditor());
			}
        } else {
            ViLayerFactory.getInstance().unLoadAllLayers();
			window.getPartService().removePartListener(partListener);
			IEditorPart editor = window.getActivePage().getActiveEditor();
            if (editor != null) {
				editor
					.getEditorSite()
					.getActionBars()
					.getStatusLineManager()
					.setMessage(
					"viPlugin unloaded!");
			}
		}
		toggled = !toggled;
	}
	
	/**
	 * Selection in the workbench has been changed. We 
	 * can change the state of the 'real' action here
	 * if we want, but this can only happen after 
	 * the delegate has been created.
	 * @see IWorkbenchWindowActionDelegate#selectionChanged
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		// not used by ViPlugin
    }

	/**
	 * We can use this method to dispose of any system
	 * resources we previously allocated.
	 * @see IWorkbenchWindowActionDelegate#dispose
	 */
	public void dispose() {
		// not used by ViPlugin
    }

	/**
	 * We will cache window object in order to
	 * be able to provide parent shell for the message dialog.
	 * @see IWorkbenchWindowActionDelegate#init
	 */
	public void init(IWorkbenchWindow window) {
		this.window = window;
		ViLayerFactory.init(window);
	}
}
