/*
 * Created on 20.08.2003
 */
package viPlugin;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Shell;

public class ViVerifyKeyListener implements VerifyKeyListener {

	private final ViLayer _layer;
	public static final char ENTER = (char) 13;
	public static final String ENTER_STRING = String.valueOf(ENTER);

	/**
	 * @param ViLayer
	 */
	ViVerifyKeyListener(ViLayer layer) {
		_layer = layer;
	}

	public void verifyKey(VerifyEvent e) {
//		System.out.println(
//			"VerifyEvent = "
//				+ (int) e.character
//				+ ", "
//				+ e.keyCode
//				+ ", "
//				+ e.stateMask);
		if (e.character == SWT.ESC
			&& (_layer.isInInsertMode() || _layer.isInVisualMode())) {
			// close IME window for platform
			// NOTE: display is null on MAC-OS
			if (e.display != null) {
				Shell shell = e.display.getActiveShell();
				if (shell != null) {
					shell.setImeInputMode(SWT.NONE);
				}
			}
			e.doit = false;
			if (_layer.isInInsertMode()) {
				_layer.switchToCommandMode();
			} else if (_layer.isInVisualMode()) {
				_layer.leaveVisualMode();
			}
		} else if (_layer.isInCommandMode() || _layer.isInVisualMode()) {
			inCommandMode(e);
		}
		if (!e.doit) {
			_layer.setStatusLine();
		}
	}

	private void inCommandMode(VerifyEvent e) {
		// not keyCode but character for Ctrl+M and IME.
		switch (e.character) {
			case 0 : // Arrow, Ctrl, Shift, Alt, Arrow key.
				if (e.keyCode == SWT.ARROW_DOWN
					&& e.stateMask == SWT.MODELESS) {
					_layer.commandBuffer.append("<CD>");
					_layer.commandBuffer.eval();
					e.doit = false;
					break;
				}
				if (e.keyCode == SWT.ARROW_UP && e.stateMask == SWT.MODELESS) {
					_layer.commandBuffer.append("<CU>");
					_layer.commandBuffer.eval();
					e.doit = false;
					break;
				}
				if (e.keyCode == SWT.ARROW_LEFT
					&& e.stateMask == SWT.MODELESS) {
					_layer.commandBuffer.append("<CL>");
					_layer.commandBuffer.eval();
					e.doit = false;
					break;
				}
				if (e.keyCode == SWT.ARROW_RIGHT
					&& e.stateMask == SWT.MODELESS) {
					_layer.commandBuffer.append("<CR>");
					_layer.commandBuffer.eval();
					e.doit = false;
					break;
				} else {
					e.doit = true;
					break;
				}
			case SWT.BS :
				_layer.commandBuffer.backspace();
				_layer.commandBuffer.eval();
				e.doit = false;
				break;
			case SWT.DEL :
				_layer.commandBuffer.append("x");
				_layer.commandBuffer.eval();
				e.doit = false;
				break;
			case 13 : // ENTER
				// close IME window for platform.
				// NOTE: display is null on MAC-OS
				if (e.display != null) {
					e.display.getActiveShell().setImeInputMode(SWT.NONE);
				}
				_layer.commandBuffer.append(e.character);
				// \n following / or :
				_layer.commandBuffer.eval();
				e.doit = false;
				break;
			case 'U' : // redo key for now
				if (_layer.commandBuffer.getCommand().startsWith(":")
					|| _layer.commandBuffer.getCommand().startsWith("/"))
					_layer.commandBuffer.append(e.character);
				else
					_layer.commandBuffer.append("<REDO>");
				_layer.commandBuffer.eval();
				e.doit = false;
				break;
				// <vim> page-up
			case 'Q' :
				if (_layer.commandBuffer.getCommand().startsWith(":")
					|| _layer.commandBuffer.getCommand().startsWith("/"))
					_layer.commandBuffer.append(e.character);
				else
					_layer.commandBuffer.append("<PU>");
				_layer.commandBuffer.eval();
				e.doit = false;
				break;
				// <vim> page-down
			case 'q' :
				if (_layer.commandBuffer.getCommand().startsWith(":")
					|| _layer.commandBuffer.getCommand().startsWith("/"))
					_layer.commandBuffer.append(e.character);
				else
					_layer.commandBuffer.append("<PD>");
				_layer.commandBuffer.eval();
				e.doit = false;
				break;
				// <vim> scroll up
/*			case 'V' :
				if (_layer.commandBuffer.getCommand().startsWith(":")
					|| _layer.commandBuffer.getCommand().startsWith("/"))
					_layer.commandBuffer.append(e.character);
				else
					_layer.commandBuffer.append("<SU>");
				_layer.commandBuffer.eval();
				e.doit = false;
				break;
				// <vim> scroll up
			case 'v' :
				if (_layer.commandBuffer.getCommand().startsWith(":")
					|| _layer.commandBuffer.getCommand().startsWith("/"))
					_layer.commandBuffer.append(e.character);
				else
					_layer.commandBuffer.append("<SD>");
				_layer.commandBuffer.eval();
				e.doit = false;
				break;
*/			default :
				_layer.commandBuffer.append(e.character);
				_layer.commandBuffer.eval();
				e.doit = false;
				break;
		}
	}
}
